/*
 * SAP Copyright (c) 2003
 * All rights reserved
 * 
 * @version $Id: //tc/WebDynproRuntime/630_VAL_REL/src/_webdynpro_runtime_repository_pmr/src/packages/com/sap/tc/webdynpro/progmodel/repository/enum/WDControllerTypeEnumInfo.java#1 $
 */

package com.sap.tc.webdynpro.progmodel.repository.enum;

import java.util.Enumeration;
import java.util.Hashtable;

/**
 * Enumeration for controller types. 
 * @author SAP
 */
public class WDControllerTypeEnumInfo
{
  /**
   * Component controller. 
   */
  public static final WDControllerTypeEnumInfo COMPONENT = new WDControllerTypeEnumInfo("component");
  
  /**
   * Component configuration controller.
   */
  public static final WDControllerTypeEnumInfo COMPONENT_CONFIGURATION = new WDControllerTypeEnumInfo("component_configuration");
  
  /**
   * Component interface controller.
   */
  public static final WDControllerTypeEnumInfo COMPONENT_INTERFACE = new WDControllerTypeEnumInfo("component_interface");
  
  /**
   * Custom controller.
   */
  public static final WDControllerTypeEnumInfo CUSTOM = new WDControllerTypeEnumInfo("custom");
  
  /**
   * Interface view controller.
   */
  public static final WDControllerTypeEnumInfo INTERFACE_VIEW = new WDControllerTypeEnumInfo("interface_view");
  
  /**
   * View controller.
   */
  public static final WDControllerTypeEnumInfo VIEW = new WDControllerTypeEnumInfo("view");

  private static Hashtable mMemberTable = init();
  private String mStringValue = null;

  // WDControllerTypeEnumInfo()
  private WDControllerTypeEnumInfo(String value)
  {
    mStringValue = value;
  }

  /**
   * Returns an enumeration of the legal values of this enerumeration type.
   * @return an enumeration of the legal values of this enerumeration type
   */
  public static Enumeration enumerate()
  {
    return mMemberTable.elements();
  }

  // init()
  private static Hashtable init()
  {
    Hashtable members = new Hashtable();
    members.put("component", COMPONENT);
    members.put("component_configuration", COMPONENT_CONFIGURATION);
    members.put("component_interface", COMPONENT_INTERFACE);
    members.put("custom", CUSTOM);
    members.put("interface_view", INTERFACE_VIEW);
    members.put("view", VIEW);
    return members;
  }

  /**
   * Returns the string representation for this enumeration value.
   * @return the string representation for this enumeration value.
   */
  public String toString()
  {
    return mStringValue;
  }

  /**
   * Returns the enumeration value corresponding to the given string
   * representation.
   * @param string string representation of an enumeration value
   * @return the enumeration value corrseponding to the given string 
   * representation or null if it does not exist
   */
  public static WDControllerTypeEnumInfo valueOf(String string)
  {
    Object obj = null;
    if (string != null) obj = mMemberTable.get(string);
    return (WDControllerTypeEnumInfo) obj;
  }
}
