/*
 * SAP Copyright (c) 2003
 * All rights reserved
 * 
 * @version $Id: //tc/WebDynproRuntime/630_VAL_REL/src/_webdynpro_runtime_repository_pmr/src/packages/com/sap/tc/webdynpro/progmodel/repository/enum/WDContextElementMappingTypeEnumInfo.java#1 $
 */

package com.sap.tc.webdynpro.progmodel.repository.enum;

import java.util.Enumeration;
import java.util.Hashtable;

/**
 * Enumeration for context element mapping types. 
 * @author SAP
 */
public class WDContextElementMappingTypeEnumInfo
{
  /**
   * The collection and the selection of the context node is mapped.
   */
  public static final WDContextElementMappingTypeEnumInfo COLLECTION_AND_SELECTION = new WDContextElementMappingTypeEnumInfo("collection_and_selection");
  
  /**
   * Only the collection of the context node is mapped.
   */
  public static final WDContextElementMappingTypeEnumInfo COLLECTION_ONLY = new WDContextElementMappingTypeEnumInfo("collection_only");
  
  /**
   * The property context element mapping type is not applicable for the
   * context element.
   */
  public static final WDContextElementMappingTypeEnumInfo NOT_APPLICABLE = new WDContextElementMappingTypeEnumInfo("not_applicable");

  private static Hashtable mMemberTable = init();
  private String mStringValue = null;

  // WDContextElementMappingTypeEnumInfo()
  private WDContextElementMappingTypeEnumInfo(String value)
  {
    mStringValue = value;
  }

  /**
   * Returns an enumeration of the legal values of this enerumeration type.
   * @return an enumeration of the legal values of this enerumeration type
   */
  public static Enumeration enumerate()
  {
    return mMemberTable.elements();
  }

  // init()
  private static Hashtable init()
  {
    Hashtable members = new Hashtable();
    members.put("collection_and_selection", COLLECTION_AND_SELECTION);
    members.put("collection_only", COLLECTION_ONLY);
    members.put("not_applicable", NOT_APPLICABLE);
    return members;
  }

  /**
   * Returns the string representation for this enumeration value.
   * @return the string representation for this enumeration value.
   */
  public String toString()
  {
    return mStringValue;
  }

  /**
   * Returns the enumeration value corresponding to the given string
   * representation.
   * @param string string representation of an enumeration value
   * @return the enumeration value corrseponding to the given string 
   * representation or null if it does not exist
   */
  public static WDContextElementMappingTypeEnumInfo valueOf(String string)
  {
    Object obj = null;
    if (string != null) obj = mMemberTable.get(string);
    return (WDContextElementMappingTypeEnumInfo) obj;
  }
}
