/*
 * SAP Copyright (c) 2003
 * All rights reserved
 * 
 * @version $Id: //tc/WebDynproRuntime/630_VAL_REL/src/_webdynpro_runtime_repository_pmr/src/packages/com/sap/tc/webdynpro/progmodel/repository/enum/WDComponentLifecycleEnumInfo.java#1 $
 */

package com.sap.tc.webdynpro.progmodel.repository.enum;

import java.util.Enumeration;
import java.util.Hashtable;

/**
 * Enumeration for component lifecycle control values. 
 * @author SAP
 */
public class WDComponentLifecycleEnumInfo
{
  /**
   * Manually create and delete component instances.
   */
  public static final WDComponentLifecycleEnumInfo MANUAL = new WDComponentLifecycleEnumInfo("manual");

  /**
   * A component instance is automatically created on the first time it is
   * required if it has not been created manually before.
   */
  public static final WDComponentLifecycleEnumInfo CREATE_ON_DEMAND = new WDComponentLifecycleEnumInfo("createOnDemand");

  private static Hashtable mMemberTable = init();
  private String mStringValue = null;

  // WDContextElementMappingTypeEnumInfo()
  private WDComponentLifecycleEnumInfo(String value)
  {
    mStringValue = value;
  }

  /**
   * Returns an enumeration of the legal values of this enerumeration type.
   * @return an enumeration of the legal values of this enerumeration type
   */
  public static Enumeration enumerate()
  {
    return mMemberTable.elements();
  }

  // init()
  private static Hashtable init()
  {
    Hashtable members = new Hashtable();
    members.put("manual", MANUAL);
    members.put("createOnDemand", CREATE_ON_DEMAND);
    return members;
  }

  /**
   * Returns the string representation for this enumeration value.
   * @return the string representation for this enumeration value.
   */
  public String toString()
  {
    return mStringValue;
  }

  /**
   * Returns the enumeration value corresponding to the given string
   * representation.
   * @param string string representation of an enumeration value
   * @return the enumeration value corrseponding to the given string 
   * representation or null if it does not exist
   */
  public static WDComponentLifecycleEnumInfo valueOf(String string)
  {
    Object obj = null;
    if (string != null) obj = mMemberTable.get(string);
    return (WDComponentLifecycleEnumInfo) obj;
  }
}
