/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id: //kmgmt/bc.sf.service/60NW_SP_COR/src/_landscape/java/api/com/sapportals/wcm/service/landscape/SystemInfo.java#1 $
 */

package com.sapportals.wcm.service.landscape;

import com.sap.tc.logging.Location;

/**
 * Allows to set the id of the local CM system, before starting the landscape
 * service. <br>
 *
 */
public class SystemInfo {
  private final static Location LOC = Location.getLocation(com.sapportals.wcm.service.landscape.SystemInfo.class);

  private static String systemId;


  /**
   * @return The current id of the sytem as a string
   */
  public static String getSystemId() {
    return SystemInfo.systemId;
  }


  /**
   * @param id The cm system name of the local system (must be unique for
   *      clusters)
   */
  public static void setSystemId(String id) {
    LOC.debugT("setSystemId(44)", "System id set to " + id);
    SystemInfo.systemId = id;
  }

}
