/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id: //kmgmt/bc.sf.service/60NW_SP_COR/src/_landscape/java/api/com/sapportals/wcm/service/landscape/ISystemList.java#2 $
 */

package com.sapportals.wcm.service.landscape;

/**
 * A list of <code>ISystem</code> s. <br>
 *
 *
 * @author Jens Kaiser
 * @version $Id: //kmgmt/bc.sf.service/dev/src/_landscape/java/api/com/sapportals/wcm/service/landscape/ISystemList.java#4
 *      $
 */
public interface ISystemList {

  /**
   * Get an iterator for the list of systems
   *
   * @return a <code>ISystemListIterator</code> with the iterator for the list.
   */
  public ISystemListIterator iterator();


  /**
   * Add a system to the system list
   *
   * @param system Description of the Parameter
   */
  void add(ISystem system);

  /**
   * Tests if a system is part of this list
   *
   * @param system TBD: Description of the incoming method parameter
   * @return TBD: Description of the outgoing return value
   */
  boolean contains(ISystem system);

  /**
   * Tests if this list is empty
   *
   * @return empty
   */
  boolean isEmpty();
  
  /**
   * Returns the number of systems cotained in this list
   * @return the number of systems cotained in this list
   */
  int size();
}
