/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id: //kmgmt/bc.sf.service/60NW_SP_COR/src/_landscape/java/api/com/sapportals/wcm/service/landscape/ISystemFactory.java#1 $
 */

package com.sapportals.wcm.service.landscape;

/**
 * Factory to retrieve <code>ISystem</code> s and the <code>ICredentialFactory
 * </code>. <br>
 *
 */
public interface ISystemFactory {

  /**
   * Get an empty system list for systems.
   *
   * @return emptySystemList
   */
  public ISystemList getEmptySystemList();


  /**
   * Get the list of all available systems.
   *
   * @return systems
   */
  public ISystemList getSystems();


  /**
   * Get a specific system.
   *
   * @param id TBD: Description of the incoming method parameter
   * @return system
   */
  public ISystem getSystem(String id);


  /**
   * Get a cm system object, unique for this system within a cluster.
   *
   * @return The unique system.
   */
  ISystem getLocalSystem();


  /**
   * Get the credentials factory.
   *
   * @return credentialsFactory
   * @exception Exception Exception raised in failure situation
   */
  public ICredentialsFactory getCredentialsFactory()
    throws Exception;
}
