/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id: //kmgmt/bc.sf.service/60NW_SP_COR/src/_landscape/java/api/com/sapportals/wcm/service/landscape/ISystem.java#3 $
 */

package com.sapportals.wcm.service.landscape;

import java.util.Enumeration;
import java.util.Locale;

/**
 * Abstraction of an 'external' system, like a web server or a R/3-System. <br>
 *
 */
public interface ISystem {

  /**
   * For your convenience: a predefined property name for the most beloved
   * "server"
   */
  public final static String SERVER_PROPERTY_NAME = "server";

  /**
   * The type of a CM system
   */
  public final static String TYPE_CM = "CM";


  /**
   * Get the system's ID
   *
   * @return id
   */
  public String getId();


  /**
   * Get the system's type (identifying the set of credentials to use).
   *
   * @return type
   */
  public String getType();


  /**
   * Get the default description for the system.
   *
   * @return description
   */
  public String getDescription();


  /**
   * Get the description for the system in a specific locale, if available.
   *
   * @param locale TBD: Description of the incoming method parameter
   * @return description
   */
  public String getDescription(Locale locale);


  /**
   * @return descriptionLocales
   * @deprecated as of NW04. No longer supported! Get an Enumeration of locale-Strings
   */
  public Enumeration getDescriptionLocales();


  /**
   * Get an enumeration of the names of all available properties.
   *
   * @return propertyNames
   */
  public Enumeration getPropertyNames();


  /**
   * Get a specific property by name.
   *
   * @param name TBD: Description of the incoming method parameter
   * @return property
   */
  public String getProperty(String name);
}
