/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id: //kmgmt/bc.sf.service/60NW_SP_COR/src/_landscape/java/api/com/sapportals/wcm/service/landscape/ILandscapeService.java#1 $
 */

package com.sapportals.wcm.service.landscape;

import com.sapportals.wcm.WcmException;
import com.sapportals.wcm.service.IService;

/**
 * Main entry point to retrieve the <code>ISystemFactory</code> and check the
 * cluster mode. <br>
 *
 */
public interface ILandscapeService
   extends IService {
  /**
   * identifier for landscape service
   */
  String LANDSCAPE_SERVICE = "LandscapeService";

  /**
   * Get the system factory.
   *
   * @return systemFactory
   * @exception WcmException Exception raised in failure situation
   */
  public ISystemFactory getSystemFactory()
    throws WcmException;


  /**
   * Indicates if the local system is within a cluster
   *
   * @return clusterInstallation
   */
  public boolean isClusterInstallation();


  /**
   * Get the configured timeout value to use for cacheing objects in a cluster
   * in a clustered environment [in msec].
   *
   * @return clusterCachingTimeout
   */
  public long getClusterCachingTimeout();

  /**
   * Retrieve an auto id object.
   *
   * @return AutoID for the given key 'tableName'
   * @exception WcmException Exception raised in failure situation
   */
  public AutoID getAutoID ( String tableName ) throws WcmException ;
}
