/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id: //kmgmt/bc.sf.service/60NW_SP_COR/src/_landscape/java/api/com/sapportals/wcm/service/landscape/ICredentialsFactory.java#1 $
 */

package com.sapportals.wcm.service.landscape;

/**
 * Factory to retrieve the <code>ICredential</code> s. <br>
 *
 */
public interface ICredentialsFactory {

  /**
   * Get a specific credential for a given system type (credential set) by name.
   *
   * @param systemType TBD: Description of the incoming method parameter
   * @param name TBD: Description of the incoming method parameter
   * @return credential
   */
  public ICredential getCredential(String systemType,
    String name);


  /**
   * Get all credentials for a given system type (credential set).
   *
   * @param systemType TBD: Description of the incoming method parameter
   * @return credentials
   */
  public ICredentialList getCredentials(String systemType);

}
