/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id: //kmgmt/bc.sf.service/60NW_SP_COR/src/_landscape/java/api/com/sapportals/wcm/service/landscape/ICredentialListIterator.java#1 $
 */

package com.sapportals.wcm.service.landscape;

/**
 * An iterator for a <code>ICredentialList</code> . <br>
 *
 */
public interface ICredentialListIterator {

  /**
   * Check whether there are more entries in the list
   *
   * @return a <code>boolean</code> <code>true</code> if there are more entries
   *      in the list
   */
  public boolean hasNext();


  /**
   * Get the current element in the list and step to the next element
   *
   * @return a <code>ICredential</code> with the current element in the list
   */
  public ICredential next();

}
