/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id: //kmgmt/bc.sf.service/60NW_SP_COR/src/_landscape/java/api/com/sapportals/wcm/service/landscape/ICredential.java#1 $
 */

package com.sapportals.wcm.service.landscape;

import java.util.Enumeration;

/**
 * Informations for mapping user data between a CM system and 'external'
 * systems. <br>
 *
 */
public interface ICredential {

  /**
   * Get the credential's name.
   *
   * @return name
   */
  public String getName();


  /**
   * Get the name of the credential set this credential belongs to.
   *
   * @return systemType
   */
  public String getSystemType();


  /**
   * Get an enumeration of all available property names.
   *
   * @return propertyNames
   */
  public Enumeration getPropertyNames();


  /**
   * Get a specific property by name.
   *
   * @param name TBD: Description of the incoming method parameter
   * @return property
   */
  public String getProperty(String name);
}
