/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id:$
 */

package com.sapportals.wcm.service.landscape ;

import com.sapportals.wcm.WcmException;
import com.sap.tc.logging.Location;

/**
	 * The good old "Nummernkreis" is back: This class generates sequential
 * numbers for use as primary keys in (OpenSQL) database tables.
 * During the initialize() method all component instances on different
 * culster nodes which use the same "number range" are synchronized via
 * the central database.
 */
public final class AutoID {

  private String name ;
  private com.sapportals.wcm.util.opensql.AutoID utilAutoID ;

	/**
	 * Returns the next number of this range.
	 * @return the next number of this range.
	 */
  public synchronized long getNextID() {
		return this.utilAutoID.getNextID() ;
	}

  public AutoID ( String name ) throws WcmException {
    this.name = name ;
    this.utilAutoID = com.sapportals.wcm.util.opensql.AutoID.getAutoID ( name );
  }

	public String toString() {
		return this.name ;
	}
}
