/*
* SAP Copyright (c) 2003
* All rights reserved.
*
* @version $Id: //tc/WebDynproSampleApps/630_SP_COR/src/_webdynpro_tutorial_masterdetail/src/packages/com/sap/tc/webdynpro/tutorials/masterdetail/bol/SomeBOL.java#2 $
*/
package com.sap.tc.webdynpro.tutorials.masterdetail.bol;

import java.util.*;

/**
 * Demo Business Object Layer class used in Web Dynpro Tutorial Master-Detail-Viewer
 */
public class SomeBOL {

  // #################### Class for Business Objects of Type Customer ###################
  public class Customer {
    // ---- fields
    private String name;
    private Address address;
    private List orders;

    /** Constructors for Customer */
    public Customer(String name, Address address, List orders) {
      this.name = name;
      this.address = address;
      this.orders = orders;
    }

    // ====================== Getter Methods ========================
    public Address getAddress() {
      return address;
    }

    public String getName() {
      return name;
    }

    public List getOrders() {
      return orders;
    }
  }

  // #################### Class for Business Objects of Type Address ###################
  public class Address {
    // ---- fields
    private String street;
    private String houseNo;
    private String city;
    private String postalCode;
    private String country;

    /** Constructor for Address */
    public Address(
      // ---- fields
      String street,
      String houseNo,
      String city,
      String postalCode,
      String country) {
      this.street = street;
      this.houseNo = houseNo;
      this.city = city;
      this.postalCode = postalCode;
      this.country = country;
    }

    // ====================== Accessor-Methods ========================
    public String getCity() {
      return city;
    }

    public String getCountry() {
      return country;
    }

    public String getHouseNo() {
      return houseNo;
    }

    public String getPostalCode() {
      return postalCode;
    }

    public String getStreet() {
      return street;
    }
  }

  // #################### Class for Business Objects of Type Order ###################
  public class Order {
    // ---- fields
    private String date;
    private String product;
    private String price;
    private String currency;

    /** Constructor for Order */
    public Order(String date, String product, String price, String currency) {
      this.date = date;
      this.currency = currency;
      this.price = price;
      this.product = product;
    }

    // ====================== Getter Methods ========================
    public String getDate() {
      return date;
    }

    public String getPrice() {
      return price;
    }

    public String getProduct() {
      return product;
    }

    public String getCurrency() {
      return currency;
    }
  }

  // ------------------------ end of inner classes ---------------------------

  private Map customers;

  /** Constructor for SomeBOL */
  public SomeBOL() {
    this.customers = Collections.EMPTY_MAP;
  }

  public void initialize() {
    List orderList;
    customers = new HashMap();
    
    orderList = new ArrayList();
    orderList.add(new Order("12.10.2001", "Table", "120", "Pound"));
    orderList.add(new Order("23.05.2001", "Chair", "80", "Pound"));
    orderList.add(new Order("04.01.2000", "Desk", "200", "Pound"));
    orderList.add(new Order("17.07.2000", "Lamp", "70.5", "Pound"));
    customers.put(
       "Miller",
       new Customer(
        "Miller",
        new Address("Tabernacle Street", "10", "London", "EC2", "England"),
        orderList));

    orderList = new ArrayList();
    orderList.add(new Order("13.10.1999", "Table Noire", "120", "Euro"));
    orderList.add(new Order("23.05.2001", "Green Lamp", "80", "Euro"));
    orderList.add(new Order("04.01.2000", "Desk", "200", "Euro"));
    orderList.add(new Order("17.07.2000", "Lamp", "70.5", "Euro"));
    orderList.add(new Order("21.07.2002", "Wall Closet", "500", "Euro"));
    customers.put(
      "Schmidt",
      new Customer(
        "Schmidt",
        new Address("Bahnhofstraße", "127", "Berlin", "10407", "Germany"),
        orderList));

    orderList = new ArrayList();
    orderList.add(new Order("13.10.1997", "Floor Lamp", "180", "Dollar"));
    orderList.add(new Order("23.05.2001", "Commode", "300", "Dollar"));
    orderList.add(new Order("08.01.2002", "Rack", "199", "Dollar"));
    orderList.add(new Order("17.08.1998", "Lamp (Halogene)", "100", "Dollar"));
    orderList.add(new Order("11.10.1997", "Davenport", "219", "Dollar"));
    customers.put(
      "Smith",
      new Customer(
        "Smith",
        new Address(
          "Square Garden",
          "215 West 34th Street",
          "New York",
          "10102",
          "USA"),
        orderList));
  }

  public Collection getCustomers() {
    return customers.values();
  }

  public Collection getOrdersForCustomer(String customerName) {
     return ((Customer)customers.get(customerName)).getOrders(); 
  }
}