<?xml version="1.0"?>
<xsl:transform xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">  
  
<xsl:output indent="yes" 
            doctype-system="web-j2ee-engine.dtd"
            omit-xml-declaration="yes"/>
<xsl:template match = "text()"/>
  
<xsl:template match="/web-app">
  
  <xsl:if test="security-role/user-name or security-role/group-name">
    <web-j2ee-engine>
      <xsl:apply-templates select="security-role"/>
    </web-j2ee-engine>
  </xsl:if>

</xsl:template>
  
<xsl:template match="security-role">
  <xsl:apply-templates select="user-name"/>
  <xsl:apply-templates select="group-name"/>
</xsl:template>
  
<xsl:template match="user-name|group-name">
  <security-role-map>
    <xsl:copy-of select="../role-name"/>
    <xsl:copy-of select="."/>
  </security-role-map>
</xsl:template>
  
</xsl:transform>