<?xml version="1.0"?> 
<xsl:transform xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">

<xsl:output method="text" indent="no"/>

<!-- The main template -->

<xsl:template match="Class">
/**
 * Class generated by InQMy Generator
 * Don't change it !!
 *
 * Copyright (c) 2000 by InQMy Software AG.,
 * url: http://www.inqmy.com
 * All rights reserved.
 *
 * This software is the confidential and proprietary information
 * of InQMy Software AG. You shall not disclose such Confidential
 * Information and shall use it only in accordance with the terms
 * of the license agreement you entered into with InQMy.
 */ 
<xsl:if test="count(Package)=1">package <xsl:value-of select="Package"/>;</xsl:if>

import java.io.Serializable;
import java.rmi.Remote;
import java.rmi.RemoteException;
import javax.rmi.CORBA.Tie;
import javax.rmi.CORBA.Util;
import javax.rmi.PortableRemoteObject;
import org.omg.CORBA.BAD_OPERATION;
import org.omg.CORBA.NO_PERMISSION;
import org.omg.CORBA.ORB;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.portable.InputStream;
import org.omg.CORBA.portable.OutputStream;
import org.omg.CORBA.portable.ResponseHandler;
import org.omg.CORBA.portable.UnknownException;
import org.omg.CORBA_2_3.portable.ObjectImpl;

//import com.inqmy.frame.ThreadContext;
<xsl:if test="not(count(//ResourceId)=0)">
import com.sap.engine.services.iiop.server.IIOPProvider;
import com.sap.engine.frame.container.security.ResourceContext;
import com.sap.engine.frame.container.security.ResourceHandle;
</xsl:if>
/**
 * @ version 6.30
 */

public class <xsl:apply-templates select="Name"/> extends ObjectImpl implements Tie {

	private <xsl:value-of select="Name"/> target = null;

	<xsl:if test="not(count(//ResourceId)=0)"><xsl:text>private static final int resourceId = </xsl:text><xsl:value-of select="ResourceId"/>; 
	private ResourceContext resourceCtx;
	private int[] actionId;

	private static final String[] aliases = {
		<xsl:for-each select="Method">"<xsl:value-of select="./Name"/>(<xsl:for-each select="./Parameter/Type"><xsl:value-of select="."/><xsl:if test="position()!=last()">,</xsl:if></xsl:for-each>)"<xsl:if test="position()!=last()">,
		</xsl:if></xsl:for-each>
	};
	</xsl:if>
	private static final String[] type_ids = {
	      <xsl:choose>
		<xsl:when test="count(RMIRepositoryID)=1">
			<xsl:for-each select="RMIRepositoryID">"<xsl:value-of select="."/>"<xsl:if test="position()!=last()">, </xsl:if></xsl:for-each>
		</xsl:when>
		<xsl:otherwise>
			<xsl:for-each select="RMIRepositoryID"><xsl:if test="position()>1">"<xsl:value-of select="."/>"<xsl:if test="position()!=last()">, </xsl:if></xsl:if></xsl:for-each>
		</xsl:otherwise>
	      </xsl:choose>
	};

	public <xsl:apply-templates select="Name"/>() {<xsl:if test="not(count(//ResourceId)=0)">
		resourceCtx = IIOPProvider.getResourceContext();
		ResourceHandle handle = resourceCtx.getResourceHandle(resourceId);
	        
		actionId = new int[aliases.length];
		for (int i = 0; i &lt; aliases.length; i++) {
			try {
				actionId[i] = handle.getActionId(aliases[i]);
			} catch (Exception ex) {
				actionId[i] = Integer.MIN_VALUE;
			}
		}</xsl:if>
	}

	public void setTarget(Remote target) {
		this.target = (<xsl:value-of select="Name"/>) target;
	}

	public Remote getTarget() {
		return target;
	}

	public org.omg.CORBA.Object thisObject() {
		return this;
	}

	public void deactivate() {
		_orb().disconnect(this);
		_set_delegate(null);
		target = null;
	}

	public ORB orb() {
		return _orb();
	}

	public void orb(ORB orb) {
		orb.connect(this);
	}

	public String[] _ids() { 
		return type_ids;
	}

	public OutputStream  _invoke(String method, InputStream _in, ResponseHandler reply) throws SystemException {
		try {
			org.omg.CORBA_2_3.portable.InputStream in = 	(org.omg.CORBA_2_3.portable.InputStream) _in;
			<xsl:apply-templates select="Method"/>
			throw new BAD_OPERATION();
		} catch (SecurityException secexc){
			throw new NO_PERMISSION();
		} catch (SystemException ex) {
			throw ex;
		} catch (Exception ex) {
			ex.printStackTrace();
			throw new UnknownException(ex);
		}
	}

	private Object cast_object(Serializable obj) {
		return (Object)obj;
	}
	private Serializable cast_array(Object obj) {
		return (Serializable)obj;
	}
}
</xsl:template>

<!-- Make the Tie name -->
<xsl:template match="Name">
	<xsl:variable name="Impl" select="concat('_',.,'_Tie')"/> 
	<xsl:value-of select="$Impl"/>
</xsl:template>

<xsl:template match="Method">
<xsl:if test="contains(.//Attribute[position()=1],'final')=false()">
			if (method.equals("<xsl:value-of select="IDLName"/>")) {
				<xsl:variable name="return"><xsl:value-of select="./ReturnType/ClassType"/></xsl:variable>
				<xsl:if test="not(count(//ResourceId)=0)">resourceCtx.checkPermission(actionId[<xsl:value-of select="number(position()-1)"/>], resourceId, ResourceHandle.ALL);</xsl:if>
				<xsl:apply-templates select="./Parameter/Type"/>
				<xsl:choose>
				<xsl:when test="count(.//Exception)>1">
				<xsl:if test="not($return='void')">
				<xsl:value-of select="$return"/> result ;</xsl:if> 
				try { 

					<xsl:if test="not($return='void')">result =</xsl:if>target.<xsl:value-of select="Name"/>(<xsl:for-each select="./Parameter/Type"><xsl:value-of select="concat('var',position())"/><xsl:if test="position()!=last()">, </xsl:if></xsl:for-each>);
				}<xsl:for-each select="./Exception"><xsl:if test="./IsRemoteException='No'"> catch (<xsl:value-of select="./Name"/> ex) {
                              

					String id = "<xsl:value-of select="./IDLRepostoryID"/>";
					org.omg.CORBA_2_3.portable.OutputStream out = (org.omg.CORBA_2_3.portable.OutputStream) reply.createExceptionReply();
					out.write_string(id);
					out.write_value(ex,<xsl:value-of select="./Name"/>.class);
					return out;
				}
				</xsl:if></xsl:for-each>
				<xsl:if test="count(./Exception[Name])=count(./Exception[Name='java.rmi.RemoteException'])">
				catch(Exception exec){
				  throw new UnknownException(exec);
				}
				</xsl:if>
				</xsl:when>
				<xsl:otherwise>
				<xsl:if test="not($return='void')">		
				<xsl:value-of select="$return"/>	result = </xsl:if>target.<xsl:value-of select="Name"/>(<xsl:for-each select="./Parameter/Type"><xsl:value-of select="concat('var',position())"/> <xsl:if test="position()!=last()">, </xsl:if></xsl:for-each>);</xsl:otherwise></xsl:choose>
				org.omg.CORBA_2_3.portable.OutputStream out =  (org.omg.CORBA_2_3.portable.OutputStream)reply.createReply();
				<xsl:choose>
				<xsl:when test="$return='int'">out.write_long(result); </xsl:when>
				<xsl:when test="$return='short'">out.write_short(result); </xsl:when>
				<xsl:when test="$return='long'">out.write_longlong(result); </xsl:when>
				<xsl:when test="$return='float'">out.write_float(result); </xsl:when>
				<xsl:when test="$return='byte'">out.write_octet(result); </xsl:when>
				<xsl:when test="$return='double'">out.write_double(result); </xsl:when>
				<xsl:when test="$return='char'">out.write_wchar(result); </xsl:when>
				<xsl:when test="$return='boolean'">	out.write_boolean(result); </xsl:when>
				<xsl:when test="$return='java.io.Serializable' or $return='java.io.Externalizable' or $return='java.lang.Object'">Util.writeAny(out, result); </xsl:when>
				<xsl:when test="./IsRemoteReturnType='Yes'">Util.writeRemoteObject(out,result); </xsl:when>
				<xsl:when test=".//ReturnType/ToWriteAsObject='Yes'">out.write_Object(result);</xsl:when>
        <xsl:when test="count(.//ReturnType[Method[Exception[Name='java.rmi.RemoteException']]])=count(.//ReturnType[Method[Name]]) and (.//ReturnType/IsInterface='Yes')">Util.writeAbstractObject(out,result); </xsl:when>
				<xsl:when test="$return='void'"></xsl:when> 
				<xsl:when test="contains($return,'[]')">out.write_value(cast_array(result), <xsl:value-of select="$return"/>.class); </xsl:when>
				<xsl:otherwise>	out.write_value((Serializable)result, <xsl:value-of select="$return"/>.class);	 </xsl:otherwise></xsl:choose>
				return out;
			} <xsl:if test="position()!=last()">else </xsl:if></xsl:if>
</xsl:template>


	<xsl:template match="Type">
				<xsl:value-of select="."/><xsl:text> </xsl:text><xsl:value-of select="concat('var',position())"/> = <xsl:choose>
				<xsl:when test=".='int'">in.read_long();
				</xsl:when>
				<xsl:when test=".='char'">in.read_wchar();
				</xsl:when>
				<xsl:when test=".='byte'">in.read_octet();
				</xsl:when>
				<xsl:when test=".='short'">in.read_short();
				</xsl:when>
				<xsl:when test=".='long'">in.read_longlong();
				</xsl:when>
				<xsl:when test=".='boolean'">in.read_boolean();
				</xsl:when>
				<xsl:when test=".='float'">in.read_float();
				</xsl:when>
				<xsl:when test=".='double'">in.read_double();
				</xsl:when>
				<xsl:when test=".='java.io.Serializable' or .='java.io.Externalizable'">(<xsl:value-of select="."/>)Util.readAny((org.omg.CORBA.portable.InputStream)in);
				</xsl:when>
				<xsl:when test=".='java.lang.Object'">Util.readAny((org.omg.CORBA.portable.InputStream)in);
				</xsl:when>
				<xsl:when test=".='org.omg.CORBA.Object'">(org.omg.CORBA.Object)in.read_Object();
				</xsl:when>
			  <xsl:when test="(../ToWriteAsObject='Yes') and (../IsInterface='Yes')">(<xsl:value-of select="../ForStubName"/>)in.read_Object(_<xsl:value-of select="../ForStubName"/>Stub.class);
          <!-- <xsl:value-of select="concat('var',position()-1)"/>); -->
				</xsl:when>
				<xsl:when test="../IsRemote='Yes'">(<xsl:value-of select="."/>)PortableRemoteObject.narrow(in.read_Object(), <xsl:value-of select="concat(.,'.class')"/>);
				</xsl:when>
				<xsl:when test="count(../Method[Exception[Name='java.rmi.RemoteException']])=count(../Method[Name]) and (../IsInterface='Yes')">(<xsl:value-of select="."/>)PortableRemoteObject.narrow(in.read_abstract_interface(), <xsl:value-of select="concat(.,'.class')"/>);
				</xsl:when>
				<xsl:when test="contains(.,'[]')">(<xsl:value-of select="."/>)cast_object(in.read_value(<xsl:value-of select="concat(.,'.class' )"/>));
				</xsl:when>
				<xsl:otherwise>	(<xsl:value-of select="."/>)in.read_value(<xsl:value-of select="concat(.,'.class' )"/>);
				</xsl:otherwise>
				</xsl:choose>
	</xsl:template>

</xsl:transform>