<?xml version="1.0"?> 
<xsl:transform xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">

<!--<xsl:strip-space elements="*"/>-->
<xsl:output method="text" indent="no"/>

4/11/01<!-- The main template -->

<xsl:template match="Class">
/**
 * Class generated by InQMy Generator
 * Don't change it !!
 *
 * Copyright (c) 2000 by InQMy Software AG.,
 * url: http://www.inqmy.com
 * All rights reserved.
 *
 * This software is the confidential and proprietary information
 * of InQMy Software AG. You shall not disclose such Confidential
 * Information and shall use it only in accordance with the terms
 * of the license agreement you entered into with InQMy.
 */ 
<xsl:if test="count(.//StubPackage)=1 and count(.//SuperInterface)=1 and not(.//Attribute[last()]='interface')">package <xsl:value-of select=".//StubPackage"/>;</xsl:if>
<xsl:if test="count(Package)=1 and (Attribute[last()]='interface')">package <xsl:value-of select="Package"/>;</xsl:if>
<xsl:if test="count(Package)=1 and count(.//SuperInterface)>1 and (Attribute[last()]='class')">package <xsl:value-of select="Package"/>;</xsl:if>

import java.io.Serializable;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.UnexpectedException;
import javax.rmi.CORBA.Stub;
import javax.rmi.CORBA.Util;
import javax.rmi.PortableRemoteObject;
import org.omg.CORBA.ORB;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.portable.ApplicationException;
import org.omg.CORBA.portable.InputStream;
import org.omg.CORBA.portable.OutputStream;
import org.omg.CORBA.portable.RemarshalException;
import org.omg.CORBA.portable.ResponseHandler;
import org.omg.CORBA.portable.ServantObject;

//import com.sap.engine.frame.ThreadContext;

/**
 * @ version 6.30
 */
<!-- Apply the templates(like calling methods) -->
public class <xsl:apply-templates select="Name"/> extends Stub implements <xsl:choose>
	<xsl:when test="count(SuperInterface)>1"><xsl:for-each select="SuperInterface"><xsl:value-of select="."/><xsl:if test="not(position()=last())">, </xsl:if></xsl:for-each></xsl:when>
	<xsl:otherwise>	<xsl:value-of select="ForStubName"/></xsl:otherwise></xsl:choose> {

	private static final String[] type_ids = {
	      <xsl:choose>
		<xsl:when test="count(RMIRepositoryID)=1">
			<xsl:for-each select="RMIRepositoryID">"<xsl:value-of select="."/>"<xsl:if test="position()!=last()">, </xsl:if></xsl:for-each>
		</xsl:when>
		<xsl:otherwise>
			<xsl:for-each select="RMIRepositoryID"><xsl:if test="position()>1">"<xsl:value-of select="."/>"<xsl:if test="position()!=last()">, </xsl:if></xsl:if></xsl:for-each>
		</xsl:otherwise>
	      </xsl:choose>
	};

	public String[] _ids() { 
		return type_ids;
	}

	<xsl:apply-templates select="Method"/>

	private Serializable cast_array(Object obj) {
		return (Serializable)obj;
	}

	private Object cast_object(Serializable obj) {
		return (Object)obj;
	}
} 
</xsl:template>

<!-- Make the Stub name -->
<xsl:template match="Name">
<xsl:choose>
	<xsl:when test="count(../SuperInterface)>1">
		<xsl:value-of select="concat('_',.,'_Stub')"/>
	</xsl:when>
	<xsl:otherwise>
	<xsl:value-of select="concat('_',../ForStubName,'_Stub')"/>
	</xsl:otherwise>
</xsl:choose>
</xsl:template>

<!-- Pass the parameters for each method 
<xsl:template match="Parameter">
	<xsl:value-of select="./Type"/><xsl:text> </xsl:text><xsl:value-of select="concat('var',position())"/>	
	<xsl:if test="not(position()=last())">, </xsl:if>
</xsl:template>  -->
	
<!-- Write the Stub's methods -->
<xsl:template match="Method">
<!-- If the method is not a final one -->
<xsl:if test="contains(.//Attribute[position()=1],'final')=false()">

	<xsl:value-of select="AccessFlag"/><xsl:text> </xsl:text><xsl:value-of select="./ReturnType/ClassType"/><xsl:text> </xsl:text>
	<xsl:value-of select="Name"/>(<xsl:for-each select="./Parameter/Type"><xsl:value-of select="concat(.,' var',position()-1)"/><xsl:if test="position()!=last()">, </xsl:if></xsl:for-each>)<xsl:for-each select="Exception"><xsl:if test="position()=1"><xsl:text> </xsl:text>throws<xsl:text> </xsl:text></xsl:if><xsl:value-of select="./Name"/>
	<xsl:if test="not(position()=last())">, </xsl:if></xsl:for-each>
	<!-- If the method is not a native one -->
	<xsl:if test="contains(.//Attribute[last()],'native') or contains(.//Attribute[1],'native')=true() or contains(.//Attribute[2],'native')">;</xsl:if>
	<xsl:if test="not(contains(.//Attribute,'native'))">	{
		try {
			if (!Util.isLocal(this)) {
				try {
					org.omg.CORBA_2_3.portable.InputStream in = null;
					try {	<xsl:variable name="return"><xsl:value-of select="./ReturnType/ClassType"/></xsl:variable>
						org.omg.CORBA_2_3.portable.OutputStream out = (org.omg.CORBA_2_3.portable.OutputStream)_request("<xsl:value-of select="IDLName"/>", true);
						<xsl:apply-templates select="Parameter/Type"/>
						<!-- Make the result to be returned depending on the method's return type -->
						<xsl:if test="not($return='void')"> in = (org.omg.CORBA_2_3.portable.InputStream)_invoke(out);
						</xsl:if>
						<xsl:choose>
						<xsl:when test="$return='int'">int result = in.read_long();</xsl:when>
						<xsl:when test="$return='short'">short result = in.read_short();</xsl:when>
						<xsl:when test="$return='long'">long result = in.read_longlong();	</xsl:when>
						<xsl:when test="$return='float'">float result = in.read_float();</xsl:when>
						<xsl:when test="$return='byte'">byte result = in.read_octet();</xsl:when>
						<xsl:when test="$return='double'">double result = in.read_double();</xsl:when>
						<xsl:when test="$return='char'">char result = in.read_char();</xsl:when>
						<xsl:when test="$return='boolean'">boolean result = in.read_boolean();</xsl:when>
						<xsl:when test="$return='java.io.Serializable' or .//ReturnType/ClassType='java.io.Externalizable'">
						<xsl:value-of select="$return"/> result = (<xsl:value-of select="$return"/>)Util.readAny((org.omg.CORBA.portable.InputStream)in);</xsl:when>
						<xsl:when test="$return='java.lang.Object'"><xsl:value-of select="$return"/> result =Util.readAny((org.omg.CORBA.portable.InputStream)in);</xsl:when>
						<xsl:when test=".//IsRemoteReturnType='Yes'">
						<xsl:value-of select="$return"/> result =(<xsl:value-of select="$return"/>)PortableRemoteObject.narrow(in.read_Object(), <xsl:value-of select="$return"/>.class);</xsl:when>
						<xsl:when test="count(.//ReturnType[Method[Exception[Name='java.rmi.RemoteException']]])=count(.//ReturnType[Method[Name]]) and (count(.//ReturnType[Method[Name]])>0 and (.//ReturnType/IsInterface='Yes'))">
						<xsl:value-of select="$return"/> result =(<xsl:value-of select="$return"/>)PortableRemoteObject.narrow(in.read_abstract_interface(), <xsl:value-of select="$return"/>.class);</xsl:when>
						<xsl:when test="$return='void'">  _invoke(out);</xsl:when>
            <xsl:when test="$return='org.omg.CORBA.Object'"><xsl:value-of select="$return"/> result = (<xsl:value-of select="$return"/>)in.read_Object();</xsl:when>
            <xsl:when test="(.//ReturnType/ToWriteAsObject='Yes') and (.//ReturnType/IsInterface='Yes')"><xsl:value-of select="$return"/> result = (<xsl:value-of select="$return"/>)in.read_Object(_<xsl:value-of select=".//ReturnType/ForStubName"/>Stub.class);</xsl:when>
						<xsl:otherwise>	<xsl:value-of select="$return"/> result = (<xsl:value-of select="$return"/>)in.read_value();</xsl:otherwise>
						</xsl:choose>
						<xsl:if test="not($return='void')">
						return result;</xsl:if>
					<!-- Pass the method's exceptions -->
					} catch (ApplicationException ex) {
						ex.printStackTrace();
						in = (org.omg.CORBA_2_3.portable.InputStream) ex.getInputStream();
						String id = in.read_string();
						<xsl:if test="count(./Exception)>1">
						<xsl:for-each select="./Exception">
						<xsl:if test="./IsRemoteException='No'">
						if (id.equals("<xsl:value-of select="./IDLRepostoryID"/>")) {
							throw (<xsl:value-of select="./Name"/>) in.read_value(<xsl:value-of select="./Name"/>.class);
						}</xsl:if></xsl:for-each></xsl:if>
						throw new RuntimeException(id);//throw new UnexpectedException(id);
					} catch (RemarshalException ex) {
						ex.printStackTrace();
						<xsl:choose>
							<xsl:when test="not($return='void')">return </xsl:when>	
							<xsl:otherwise>	</xsl:otherwise>
						</xsl:choose><xsl:value-of select="Name"/>(<xsl:for-each select="./Parameter/Type"><xsl:value-of select="concat('var',position()-1)"/><xsl:if test="position()!=last()">, </xsl:if></xsl:for-each>);
					} finally {
					 //   _releaseReply(in);
					}
				} catch (SystemException ex) {
					ex.printStackTrace();
					throw Util.mapSystemException(ex);
				}
			} else {
			<xsl:variable name="class"><xsl:choose>
				<xsl:when test="count(../SuperInterface)>1"><xsl:value-of select="concat(../Package,'.',../Name)"/></xsl:when>
				<xsl:otherwise>	<xsl:value-of select="../ForStubName"/></xsl:otherwise></xsl:choose></xsl:variable>
				ServantObject so = _servant_preinvoke("<xsl:value-of select="IDLName"/>", <xsl:value-of select="concat($class,'.class')"/>);
				if (so == null) {
					<xsl:choose>
					<xsl:when test="not($return='void')">return </xsl:when>
					<xsl:otherwise></xsl:otherwise></xsl:choose><xsl:text> </xsl:text><xsl:value-of select="Name"/>(<xsl:for-each select="./Parameter/Type"><xsl:value-of select="concat('var',position()-1)"/><xsl:if test="position()!=last()">, </xsl:if></xsl:for-each>);
				}
				try {	
					<xsl:for-each select="./Parameter/Type">
					<xsl:if test="not(.='int') and not(.='short') and not(.='long') and not(.='float') and not(.='double') and not(.='byte') and not(.='char') and not(.='boolean') and not(.='void')">
					<xsl:value-of select="."/><xsl:text> </xsl:text><xsl:value-of select="concat('var',position()-1,'Copy')"/> = (<xsl:value-of select="."/>)	Util.copyObject(<xsl:value-of select="concat('var',position()-1)"/>, _orb());
					</xsl:if></xsl:for-each>
					<xsl:choose>
					<xsl:when test="not($return='int') and not($return='short') and not($return='long') and not($return='float') and not($return='double') and not($return='byte') and not($return='char') and not($return='boolean') and not($return='void')">
					<xsl:value-of select="$return"/> result = ((<xsl:value-of select="../ForStubName"/>)so.servant).<xsl:value-of select="Name"/> (<xsl:for-each select="./Parameter/Type">
						<xsl:choose>
						<xsl:when test="(.='int') or (.='short') or (.='long') or (.='float') or (.='double') or (.='byte') or (.='char') or (.='boolean') or (.='void')">
							<xsl:value-of select="concat('var',position()-1)"/><xsl:if test="position()!=last()">, </xsl:if>
						</xsl:when>
						<xsl:otherwise>
							<xsl:value-of select="concat('var',position()-1,'Copy')"/><xsl:if test="position()!=last()">, </xsl:if>
						</xsl:otherwise>
						</xsl:choose></xsl:for-each>);
					return (<xsl:value-of select="$return"/>)Util.copyObject(result, _orb());
					</xsl:when>
					<xsl:when test="$return='void'">	
					((<xsl:value-of select="$class"/>)so.servant).<xsl:value-of select="Name"/> (<xsl:for-each select="./Parameter/Type"><xsl:choose>
						<xsl:when test="(.='int') or (.='short') or (.='long') or (.='float') or (.='double') or (.='byte') or (.='char') or (.='boolean') or (.='void')">
							<xsl:value-of select="concat('var',position()-1)"/><xsl:if test="position()!=last()">, </xsl:if>
						</xsl:when>
						<xsl:otherwise>
							<xsl:value-of select="concat('var',position()-1,'Copy')"/><xsl:if test="position()!=last()">, </xsl:if>
						</xsl:otherwise>
						</xsl:choose></xsl:for-each>);
					</xsl:when>	
					<xsl:otherwise>
					return ((<xsl:value-of select="$class"/>)so.servant).<xsl:value-of select="Name"/> ( <xsl:for-each select="./Parameter/Type"><xsl:choose>
						<xsl:when test="(.='int') or (.='short') or (.='long') or (.='float') or (.='double') or (.='byte') or (.='char') or (.='boolean') or (.='void')">
							<xsl:value-of select="concat('var',position()-1)"/><xsl:if test="position()!=last()">, </xsl:if>
						</xsl:when>
						<xsl:otherwise>
							<xsl:value-of select="concat('var',position()-1,'Copy')"/><xsl:if test="position()!=last()">, </xsl:if>
						</xsl:otherwise>
						</xsl:choose></xsl:for-each>);
					</xsl:otherwise>
					</xsl:choose>
				} catch (Exception ex) {
					ex.printStackTrace();
					Exception exCopy = (Exception)Util.copyObject(ex, _orb());
					<xsl:if test="count(./Exception)>1"><xsl:for-each select="./Exception">
						<xsl:if test="not(./IsRemoteException='No')">
						<xsl:variable name="exc"><xsl:value-of select="./Name"/></xsl:variable>
					 if (exCopy instanceof  <xsl:value-of select="$exc"/> ) {
						   throw (<xsl:value-of select="$exc"/>) exCopy;
					}</xsl:if></xsl:for-each>
					</xsl:if>
					throw new RuntimeException(exCopy.getMessage()); //throw Util.wrapException(exCopy);
				} finally {
				   // _servant_postinvoke(so);
				}
			}</xsl:if>
		} catch (RuntimeException rex) {
			rex.printStackTrace();
		   throw new RemoteException(rex.getMessage());		
		}
	}
	</xsl:if>
</xsl:template>
<!-- Write the out.write_*** methods depending on the parameters types -->
	<xsl:template match="Type">
					<xsl:choose>
					<xsl:when test=".='int'">out.write_long(<xsl:value-of select="concat('var',position()-1)"/>);
					</xsl:when>
					<xsl:when test=".='short'">out.write_short(<xsl:value-of select="concat('var',position()-1)"/>);
					</xsl:when>
					<xsl:when test=".='long'">out.write_longlong(<xsl:value-of select="concat('var',position()-1)"/>	);
					</xsl:when>
					<xsl:when test=".='float'">out.write_float(<xsl:value-of select="concat('var',position()-1)"/>);
					</xsl:when>
					<xsl:when test=".='byte'">out.write_octet(<xsl:value-of select="concat('var',position()-1)"/>);
					</xsl:when>
					<xsl:when test=".='double'">out.write_double(<xsl:value-of select="concat('var',position()-1)"/>);
					</xsl:when>
					<xsl:when test=".='char'">out.write_char(	<xsl:value-of select="concat('var',position()-1)"/>);
					</xsl:when>
					<xsl:when test=".='boolean'">out.write_boolean(<xsl:value-of select="concat('var',position()-1)"/>);
					</xsl:when>
					<xsl:when test="contains(.,'[]')">out.write_value(cast_array(<xsl:value-of select="concat('var',position()-1)"/>)<xsl:value-of select="concat(', ',. ,'.class' )"/>);
					</xsl:when>
					<xsl:when test=".='java.io.Serializable' or .='java.io.Externalizable' or .='java.lang.Object'">Util.writeAny(out, <xsl:value-of select="concat('var',position()-1)"/>);
					</xsl:when>
					<xsl:when test=".='org.omg.CORBA.Object'">out.write_Object(<xsl:value-of select="concat('var',position()-1)"/>);
					</xsl:when>
					<xsl:when test="../ToWriteAsObject='Yes'">out.write_Object(<xsl:value-of select="concat('var',position()-1)"/>);
					</xsl:when>
   					<xsl:when test="../IsRemote='Yes'">Util.writeRemoteObject(out, <xsl:value-of select="concat('var',position()-1)"/>);
   					</xsl:when>
					<xsl:when test="count(../Method[Exception[Name='java.rmi.RemoteException']])=count(../Method[Name]) and (../IsInterface='Yes')">Util.writeAbstractObject(out, <xsl:value-of select="concat('var',position()-1)"/>);  
					</xsl:when>
					<xsl:otherwise>	out.write_value((Serializable)<xsl:value-of select="concat('var',position()-1)"/>);
					</xsl:otherwise></xsl:choose>
	</xsl:template>
</xsl:transform>