/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id$
 */

package com.sap.netweaver.bc.rf.mi.version;
import com.sap.netweaver.bc.rf.common.*;

import com.sap.netweaver.bc.rf.common.exception.*;

import java.util.*;

//TODO mba: insert @link, @see etc. tags where applicable.
//TODO mba: specify ResourceException subtypes on methods that throw specific exceptions

/**
 * Read-only interface describing a repository sub manager for the workspace
 * versioning feature. For an explanation of terminological conventions, please
 * see IBasicVersioningMananger. <p>
 *
 * Workspaces are collections that may be created incertain server-defined
 * collections. Every resource which is a descendant of a workspace is called a
 * 'workspace controlled resource' or wcr. In every worksapce controlled
 * collection, it is possible to create vcrs using a given version history
 * resource. The newly created vcr will behave essentially like a working
 * resource, the main difference being the client controlled naming and the
 * guarantee that two vcrs in the same workspace will not share their version
 * history (unless they are not bindings to the same resource). <p>
 *
 * Precondition for the support of this interface is support of <code>
 * IAdvancedVersioningManager</code> and the support of bindings, at least
 * internally.
 *
 * @author manfred.baedke@greenbytes.de
 * @created 20. Mrz 2003
 */
public interface IWorkspaceManager {

  /**
   * Return the <code>Set</code> of collection handles where workspaces can be
   * created. This set may vary depending on the given resource handle, e.g.
   * different parts of the repository namespace may have different workspace
   * collection sets.
   *
   * @param resourceHandle a resource handle
   * @return the <code>Set</code> of workspace collections for the given
   *      resource handle
   * @exception ResourceException if the resource handle is invalid or the
   *      operation failed
   */
  public Set getWorkspaceCollectionSet(IResourceHandle resourceHandle)
    throws ResourceException;


  /**
   * If the given resource handle belongs to a workspace controlled resource, a
   * resource handle referring to it's workspace resource will be returned.
   *
   * @param resourceHandle a resource handle
   * @return a resource handle referring to a workspace resource (may be null)
   * @exception ResourceException if the resource handle is invalid or the
   *      operation failed
   */
  public IResourceHandle getWorkspaceResource(IResourceHandle resourceHandle)
    throws ResourceException;


  /**
   * Returns the <code>Set</code> of resource handles referring to checked-out
   * vcrs belonging to the workspace identified by the given resource handle.
   *
   * @param workspaceHandle a workspace resource handle
   * @return the resource handles referring to checked-out resources contained
   *      in the given workspace
   * @exception ResourceException if the resource handle is invalid or the
   *      operation failed
   */
  public Set getCheckedOutResources(IResourceHandle workspaceHandle)
    throws ResourceException;
}
