/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id$
 */

package com.sap.netweaver.bc.rf.mi.version;
import com.sap.netweaver.bc.rf.common.*;

import com.sap.netweaver.bc.rf.common.exception.*;

import java.util.*;

//TODO mba: insert @link, @see etc. tags where applicable.
//TODO mba: specify ResourceException subtypes on methods that throw specific exceptions

/**
 * Read-only interface describing a repository sub manager for the support of
 * versioned collections. For an explanation of terminological conventions,
 * please see IBasicVersioningMananger. In addition to normal vcrs, the version
 * controlled state of a versioned controlled collection contains the local
 * versioned namespace of the collection, i.e. the set of local names of
 * versioned collection members. Since the version history has to keep track of
 * changes of the version controlled state of a vcr, collection versions contain
 * information about the version controlled binding set of the collection. Since
 * collection versions do not have children, they are not collection themselves.
 * <p>
 *
 * Throughout the documentation of this class, the term 'vcc' will be used to
 * refer to a version controlled collection. <p>
 *
 * Though this interface is read-only and contains only two simple methods,
 * supporting it has a huge impact on the implementations of the other
 * versioning manager interfaces. While it is quite trivial to keep track of the
 * additional state information in a vcc's version history, the methods
 * IMutableVersioningManager.updateFromVersion() and
 * IMutableVersioningManager.undoCheckout() will become much more complex in the
 * presence of the versioned collection feature, since the restauration of the
 * versioned binding set of a collection has to handle, for example, with
 * namespace collisions and with vcrs sharing version histories. Therefore it is
 * not of much value to support this interface without supporting
 * IAdvancedVersioningManager. TODO mba: explain in detail the semantics of
 * these two methods in the presence of vccs.
 *
 * @author manfred.baedke@greenbytes.de
 * @created 20. Mrz 2003
 */
public interface IVersionedCollectionManager {

  /**
   * If the given resource handle refers to a version of a vcc, the mapping of
   * version controlled bindings for this version is returned, where the
   * mapping's key set contains the local names of the version controlled
   * internal members of the collection and the value set contains resource
   * handles of the version histories of the version controlled internal
   * members. (for an ordered collection, this will be a SortedMap)
   *
   * @param collectionVersionHandle a resource handle referring to a version of
   *      a version controlled collection
   * @return the mapping described above
   * @exception ResourceException if the resource handle is invalid or the
   *      operation failed
   */
  public Map getVersionControlledBindingMap(IResourceHandle collectionVersionHandle)
    throws ResourceException;


  /**
   * Returns the collection of local member names of the given vcc which are
   * eclipsed by members which are not under version control. Eclipsing may
   * occur as a result of the methods IMutableBasicVersioningManager.updateFromVersion()
   * and IMutableBasicVersioningManager.undoCheckOut(), when the server is
   * forced to restore the versioned local namespace from an older version and
   * detects a collision between the local names found in that version and the
   * current local names which refer to resouces not being under version
   * control. After execution of one of these two methods, the concerned binding
   * name will refer to the non-versioncontrolled member of the collection, but
   * when the binding is removed or renamed (for example by deleting or moving
   * the referred resource), the binding name will stay alive, now refering the
   * previously eclipsed version controlled member of the collection. (see <a
   * href="http://greenbytes.de/tech/webdav/rfc3253.html#PROPERTY_eclipsed-set">
   * RFC3253, section 14.1.1</a> ).
   *
   * @param vccHandle a resource handle referring to a vcc
   * @return the <code>Map</code> of internal member names of all vcrs that are
   *      currently eclipsed by a non-version-controlled internal member of the
   *      collection
   * @exception ResourceException if the resource handle is invalid or the
   *      operation failed
   */
  public Set getEclipsedSet(IResourceHandle vccHandle)
    throws ResourceException;

}
