/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id$
 */

package com.sap.netweaver.bc.rf.mi.version;
import com.sap.netweaver.bc.rf.common.*;

import com.sap.netweaver.bc.rf.common.exception.*;

//TODO mba: insert @link, @see etc. tags where applicable.
//TODO mba: specify ResourceException subtypes on methods that throw specific exceptions

/**
 * Interface describing the write methods a repository sub manager for the
 * workspace versioning feature. For an explanation of terminological
 * conventions, please see IBasicVersioningMananger.
 *
 * @author manfred.baedke@greenbytes.de
 * @created 20. Mrz 2003
 */
public interface IMutableWorkspaceManager extends IWorkspaceManager {

  /**
   * If the given handle belongs to a workspace controlled collection, a new
   * version controlled resource based on the given version handle will be
   * created. If there already exists a vcr in the same workspace using the same
   * version history, TODO mba: describe in detail.
   *
   * @param collectionHandle a resource handle referring to a workspace
   *      controlled collection
   * @param baseVersionHandle a resource handle referring to a version resource
   * @param name the local name of the new resource
   * @return a resource handle referring to the created vcr
   * @exception ResourceException if the resource handle is invalid or the
   *      operation failed
   */
  public IResourceHandle createVersionControlledResource(
    IResourceHandle collectionHandle, IResourceHandle baseVersionHandle, String name)
    throws ResourceException;


  /**
   * If the given resource handle refers to a collection that supports workspace
   * creation, a new workspace resource will be created.
   *
   * @param collectionHandle a resource handle referring to a collection
   *      resource
   * @param name the local name of the new workspace resource
   * @return a resource handle referring to the new workspace resource
   * @exception ResourceException if the resource handle is invalid or the
   *      operation failed
   */
  public IResourceHandle createWorkspace(IResourceHandle collectionHandle, String name)
    throws ResourceException;
}
