/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id$
 */

package com.sap.netweaver.bc.rf.mi.version;
import com.sap.netweaver.bc.rf.common.*;

import com.sap.netweaver.bc.rf.common.exception.*;
import com.sap.netweaver.bc.rf.common.version.*;

//TODO mba: insert @link, @see etc. tags where applicable.
//TODO mba: specify ResourceException subtypes on methods that throw specific exceptions

/**
 * Interface describing the write methods of a repository sub manager for the
 * advanced versioning features described in <code>IAdvancedVersioningManager
 * </code> . For an explanation of terminological conventions, please see
 * IBasicVersioningMananger.
 *
 * @author manfred.baedke@greenbytes.de
 * @created 20. Mrz 2003
 */
public interface IMutableAdvancedVersioningManager extends IAdvancedVersioningManager {

  //-------------------------------------checkin/checkout related methods----------------------------------------------

  /**
   * If the given resource handle refers to a vcr or a version resource, this
   * resource is checked out to create a new working resource, which is
   * essentially a new vcr with a server-provided RID, based on the given
   * version (resp. the checked-in version of the given vcr) and using the same
   * version history. <p>
   *
   * Checking out a vcr is roughly equivalent to a checkout of it's checked-in
   * version, with the following additional feature: when the newly created
   * working resource will be checked in, the given vcr will automatically be
   * updated from the newly created version. <p>
   *
   * The semantics of the forkOk parameter depends on the fork behaviour of the
   * given (checked-in) version (see <code>getCheckOutForkBehaviour()</code> ):
   * If forks are strictly allowed or forbidden (as stated by
   * getCheckOutForkBehaviour()), the parameter must be ignored. Otherwise, if
   * forkOk is false and the server expects a subsequent checkin to create a
   * branched version history, the method must fail.
   *
   * @param resourceHandle a resource handle referring to a vcr or a version
   *      resource
   * @param applyToVersion checkout the checked-in version of the given vcr
   *      rather than the vcr itself
   * @param forkOk allow subsequent forks in version history upon check in
   * @return <code>ICheckOutInfo</code> object containing information about the
   *      results of the checkout process
   * @exception ResourceException if the resource handle is invalid or the
   *      operation failed
   */
  public ICheckOutInfo checkOutWorkingResource(IResourceHandle resourceHandle, boolean applyToVersion, boolean forkOk)
    throws ResourceException;

  //-------------------------------------label methods-----------------------------------------------------------------

  /**
   * Removes the given label from the given version resource, if it is present
   * there.
   *
   * @param versionHandle a resource handle referring to a version resource
   * @param label the label to remove
   * @exception ResourceException if the resource handle is invalid or the
   *      operation failed
   */
  public void removeLabel(IResourceHandle versionHandle, String label)
    throws ResourceException;


  /**
   * Tags the given version resource with the given label. If the label is
   * already present on another version in the same version history, the label
   * is removed from this latter version.
   *
   * @param versionHandle a resource handle referring to a version resource
   * @param label the label to set
   * @exception ResourceException if the resource handle is invalid or the
   *      operation failed
   */
  public void setLabel(IResourceHandle versionHandle, String label)
    throws ResourceException;


  /**
   * Tags the given version resource with the given label. If the label is
   * already present on another version in the same version history, the method
   * must fail .
   *
   * @param versionHandle a version resource handle
   * @param label the label to add
   * @exception ResourceException if the resource handle is invalid or the
   *      operation failed
   */
  public void addLabel(IResourceHandle versionHandle, String label)
    throws ResourceException;
}
