/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id$
 */

package com.sap.netweaver.bc.rf.mi.variant;

import com.sap.netweaver.bc.rf.common.*;
import com.sap.netweaver.bc.rf.common.exception.*;

/**
 * Read-Only interface describing a repository sub manager for variants.
 * Resources may be stored in a repository supporting this sub manager in
 * different variants. A variant of a resource is a specific instance of the
 * resource for a specific frame of context, e.g. in a special language or of a
 * specific MIME type. This interface allows to access the different variants of
 * such "variant-enabled" resources.
 *
 * @created 29. Januar 2003
 */
public interface IVariantManager {
  /**
   * Return true when for the given resource handle multiple variants can be
   * stored.
   *
   * @param resourceHandle resource handle
   * @return true when for the given resource handle multiple variants can be
   *      stored
   * @exception ResourceException when the resource handle is either invalid or
   *      the state can't be determined
   */
  public boolean isVariantsEnabled(IResourceHandle resourceHandle)
    throws ResourceException;

  /**
   * TBD: Unknown function (concerning selection of the resource, e.g. by
   * special MIME type or special language different from actual user language).
   * Guess: Look up variant of resource in repository by resource id and the
   * actual resource context.
   *
   * @param rid resource id to be looked up
   * @return looked up resource variant
   * @exception ResourceException when the resource id is invalid or this the
   *      resource has no variant for the given selection
   */
  public IResourceHandle lookupVariant(IRid rid)
    throws ResourceException;

  /**
   * TBD: Unknown function (concerning selection of the resource, e.g. by
   * special MIME type or special language different from actual user language).
   * Guess: Look up variant of resource in repository by resource id and the
   * actual resource context. Return only latest matching variant not older in
   * version than the given timestamp.
   *
   * @param rid resource id to be looked up
   * @param timestamp timestamp specifying the upper bound for the returned
   *      version
   * @return looked up resource variant
   * @exception ResourceException when the resource id is invalid or this the
   *      resource has no variant for the given selection matching the given
   *      timestamp upper bound
   */
  public IResourceHandle lookupVariant(IRid rid, long timestamp)
    throws ResourceException;
}
