/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id$
 */

package com.sap.netweaver.bc.rf.mi.variant;
import com.sap.netweaver.bc.rf.common.*;

import com.sap.netweaver.bc.rf.common.exception.*;

/**
 * Read-And-Write interface describing a repository sub manager for variants.
 * Resources may be stored in a repository supporting this sub manager in
 * different variants. A variant of a resource is a specific instance of the
 * resource for a specific frame of context, e.g. in a special language or of a
 * specific MIME type. This interface allows to create the different variants of
 * such "variant-enabled" resources.
 *
 * @created 29. Januar 2003
 */
public interface IMutableVariantManager extends IVariantManager {
  /**
   * Set whether or not the given resource handle should be enabled for variants
   * so that multiple variants of the resource can be stored.
   *
   * @param resourceHandle resource handle
   * @param variantsEnabled flag whether or not the given resource handle should
   *      be enabled for variants
   * @exception ResourceException when the resource handle is either invalid or
   *      can't be enabled for variants
   */
  public void setVariantsEnabled(IResourceHandle resourceHandle, boolean variantsEnabled)
    throws ResourceException;
}
