/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id$
 */

package com.sap.netweaver.bc.rf.mi.type;
import com.sap.netweaver.bc.rf.common.*;

import com.sap.netweaver.bc.rf.common.exception.*;

/**
 * Read-Only interface describing a repository sub manager for type resolval.
 * Resources may be asked if they support one or more special types, e.g. by
 * implementing further interfaces or whatever. Beside really implementing
 * further interfaces, they may contain instances or know how to instantiate or
 * get instances of one or more special types. </p> This behaviour allows
 * resources with the given limited interface of a standard resource handle to
 * be "casted" to other objects with a specific interface, e.g. to a customer or
 * contract or whatever. </p> It is also possible, to get a default instance for
 * a resource hanlde, i.e. to "cast" a resource to a default type. This is
 * useful for access layers not knowing what to access but needing the real
 * object behind it in order to give it away to another layer not knowing the
 * repository framework, but being able to handle instances of the default type.
 *
 * @created 28. Januar 2003
 */
public interface ITypeManager {
  /**
   * Check if resource IS An or providing an instance of the given requested
   * type ("instanceof"). If the requested type is null, this method returns
   * true if this resource IS An instance of the default type.
   *
   * @param resourceHandle resource handle
   * @param requestedType requested type (or null for implicit default type)
   * @return true when resource handle represents a resource being or providing
   *      an instance of the given requested resp. default type
   * @exception ResourceException when either the resource handle is invalid or
   *      the lookup wasn't successful
   */
  public boolean isA(IResourceHandle resourceHandle, Class requestedType)
    throws ResourceException;

  /**
   * Get resource AS instance of the given requested type ("cast"). If the
   * requested type is null, this method returns the resource AS an instance of
   * the default type.
   *
   * @param resourceHandle resource handle
   * @param requestedType requested type (or null for implicit default type)
   * @return instance of the given requested resp. default type
   * @exception ResourceException when either the resource handle is invalid or
   *      the lookup wasn't successful
   */
  public Object as(IResourceHandle resourceHandle, Class requestedType)
    throws ResourceException;
}
