/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id$
 */

package com.sap.netweaver.bc.rf.mi.transaction;
import com.sap.netweaver.bc.rf.common.exception.*;

import com.sap.netweaver.bc.rf.common.transaction.*;

/**
 * Read-Only interface describing a repository sub manager for transactions.
 *
 * @created 23. Januar 2003
 */
public interface ITransactionManager {
  /**
   * Get transaction actually associated with the current thread.
   *
   * @return transaction actually associated with the current thread
   * @exception RepositoryException Exception raised in failure situation
   */
  public ITransaction getTransaction()
    throws RepositoryException;
}
