/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id$
 */

package com.sap.netweaver.bc.rf.mi.transaction;
import com.sap.netweaver.bc.rf.common.exception.*;

import com.sap.netweaver.bc.rf.common.transaction.*;

/**
 * Read-And-Write interface describing a repository sub manager for
 * transactions.
 *
 * @created 23. Januar 2003
 */
public interface IMutableTransactionManager extends ITransactionManager {
  /**
   * Create a new transaction and associate it with the current thread.
   *
   * @exception RepositoryException Exception raised in failure situation
   */
  public void begin()
    throws RepositoryException;

  /**
   * Complete the transaction associated with the current thread.
   *
   * @exception RepositoryException Exception raised in failure situation
   */
  public void commit()
    throws RepositoryException;

  /**
   * Roll back the transaction associated with the current thread.
   *
   * @exception RepositoryException Exception raised in failure situation
   */
  public void rollback()
    throws RepositoryException;

  /**
   * Modify the transaction associated with the current thread such that the
   * only possible outcome of the transaction is to roll back the transaction.
   *
   * @exception RepositoryException Exception raised in failure situation
   */
  public void setRollbackOnly()
    throws RepositoryException;

  /**
   * Get status of the transaction associated with the current thread.
   *
   * @return status of the transaction associated with the current thread
   * @exception RepositoryException Exception raised in failure situation
   */
  public Status getStatus()
    throws RepositoryException;

  /**
   * Get isolation level of the transaction associated with the current thread.
   *
   * @return isolation level of the transaction associated with the current
   *      thread
   * @exception RepositoryException Exception raised in failure situation
   */
  public IsolationLevel getIsolationLevel()
    throws RepositoryException;

  /**
   * Modify the timeout value that is associated with transactions started by
   * subsequent invocations of the begin method.
   *
   * @param seconds timeout in seconds - if null, the transaction manager
   *      restores the default value
   * @exception RepositoryException Exception raised in failure situation
   */
  void setTransactionTimeout(int seconds)
    throws RepositoryException;
}
