/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id$
 */

package com.sap.netweaver.bc.rf.mi.security.acl;

/**
 * An <code>IObjectType</code> is specifies the possible type of an object, an
 * ACL can be assigned to. <br>
 *
 *
 * @created 20. Mrz 2003
 */
public interface IObjectType {
  // predefined types
  public final static String OBJECT_TYPE_NODE = "node";
  public final static String OBJECT_TYPE_LEAF = "leaf";

  /**
   * get the name of the object type
   *
   * @return the name of the object type
   */
  public String getName();

  /**
   * check whether the object type equals another object type return true iff
   * the object type equals the other object type
   *
   * @param objectType other object type to check against
   * @return result of comparison
   */
  public boolean equals(IObjectType objectType);
}
