/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id$
 */

package com.sap.netweaver.bc.rf.mi.security.acl;

import com.sap.netweaver.bc.rf.common.*;
import com.sap.netweaver.bc.rf.common.exception.*;

/**
 * Interface describing an ACL inheritance controller responsible to walk along
 * the inheritence chain of the ACL security setting propagation, e.g. if a
 * resource has no ACL settings, this controller will be asked to return the
 * parent or legator in the ACL inheritance responsible to define the ACL
 * settings for the requested resource.
 *
 * @author Vedran Lerenc
 * @created 31. Januar 2003
 */
public interface IAclInheritanceController {
  /**
   * Get parent or legator in the ACL inheritance responsible to define the ACL
   * settings for the given resource identifier, e.g. if a resource has no ACL
   * settings, this controller will be asked to return the parent or legator in
   * the ACL inheritance responsible to define the ACL settings for the given
   * resource identifier.
   *
   * @param resourceIdentifier resource identifier
   * @return resource identifier of the legator or null if there is none
   * @throws ResourceException when the resource identifier is invalid or no
   *      legator could be looked up
   */
  public IRid getLegator(IRid resourceIdentifier)
    throws ResourceException;
}
