/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id$
 */

package com.sap.netweaver.bc.rf.mi.property.datetype;

import com.sap.netweaver.bc.rf.common.exception.*;
import com.sap.netweaver.bc.rf.common.property.*;
import com.sap.netweaver.bc.rf.util.resource.*;

import java.util.*;

/**
 * Class implementing a Date multi value property used to be instantiated by
 * property sub managers. See {@link IProperty} and {@link IMutableProperty} for
 * details on properties.
 *
 * @author Vedran Lerenc
 * @created 29. Januar 2003
 * @see IMutableProperty
 * @see IProperty
 */
public class DateMultiValueProperty
   extends com.sap.netweaver.bc.rf.common.property.datetype.DateMultiValueProperty {
  /**
   * Construct property instance based on its internals.
   *
   * @param propertyType specific property type
   * @param name property name
   * @param values property values
   * @param flags bit array holding internal system attributes according to
   *      PropertyFlags bit mask fields
   * @param resourceBundles resource bundles containing (localized) property
   *      description
   * @exception ResourceException when the property creation failed
   */
  public DateMultiValueProperty(
    PropertyType propertyType,
    IPropertyName name,
    Date[] values,
    int flags,
    ResourceBundles resourceBundles)
    throws ResourceException {
    super(propertyType, name, values, null, flags, resourceBundles);
  }

  /**
   * Construct property instance based on its internals.
   *
   * @param propertyType specific property type
   * @param name property name
   * @param values property values
   * @param attributes property attributes
   * @param flags bit array holding internal system attributes according to
   *      PropertyFlags bit mask fields
   * @param resourceBundles resource bundles containing (localized) property
   *      description
   * @exception ResourceException when the property creation failed
   */
  public DateMultiValueProperty(
    PropertyType propertyType,
    IPropertyName name,
    Date[] values,
    Properties attributes,
    int flags,
    ResourceBundles resourceBundles)
    throws ResourceException {
    super(propertyType, name, values, attributes, flags, resourceBundles);
  }

  /**
   * Construct property instance based on its internals.
   *
   * @param propertyType specific property type
   * @param name property name
   * @param values property values as long
   * @param flags bit array holding internal system attributes according to
   *      PropertyFlags bit mask fields
   * @param resourceBundles resource bundles containing (localized) property
   *      description
   * @exception ResourceException when the property creation failed
   */
  public DateMultiValueProperty(
    PropertyType propertyType,
    IPropertyName name,
    long[] values,
    int flags,
    ResourceBundles resourceBundles)
    throws ResourceException {
    super(
      propertyType,
      name,
      convertLongToDateArray(values),
      null,
      flags,
      resourceBundles);
  }

  /**
   * Construct property instance based on its internals.
   *
   * @param propertyType specific property type
   * @param name property name
   * @param values property values as long
   * @param attributes property attributes
   * @param flags bit array holding internal system attributes according to
   *      PropertyFlags bit mask fields
   * @param resourceBundles resource bundles containing (localized) property
   *      description
   * @exception ResourceException when the property creation failed
   */
  public DateMultiValueProperty(
    PropertyType propertyType,
    IPropertyName name,
    long[] values,
    Properties attributes,
    int flags,
    ResourceBundles resourceBundles)
    throws ResourceException {
    super(
      propertyType,
      name,
      convertLongToDateArray(values),
      attributes,
      flags,
      resourceBundles);
  }

  /**
   * Convert long to Date array.
   *
   * @param values long array
   * @return Date array
   */
  private static Date[] convertLongToDateArray(long[] values) {
    if (values != null) {
      Date[] result = new Date[values.length];
      for (int i = 0; i < result.length; i++) {
        result[i] = new Date(values[i]);
      }
      return result;
    }
    else {
      return null;
    }
  }
}
