/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id$
 */

package com.sap.netweaver.bc.rf.mi.property;

import com.sap.netweaver.bc.rf.common.exception.*;
import com.sap.netweaver.bc.rf.common.property.*;
import com.sap.netweaver.bc.rf.common.property.booleantype.*;
import com.sap.netweaver.bc.rf.common.property.datetype.*;
import com.sap.netweaver.bc.rf.common.property.longtype.*;
import com.sap.netweaver.bc.rf.common.property.stringtype.*;

import java.util.*;

/**
 * Class implementing a factory constructing system properties for managers.
 *
 * @author Vedran Lerenc
 * @created 31. Januar 2003
 * @see IProperty
 * @see PropertyFlags
 */
public class SystemPropertyFactory extends com.sap.netweaver.bc.rf.common.property.SystemPropertyFactory {
  /**
   * Create system property.
   *
   * @param value system property value
   * @param propertyFlags system property flags
   * @return system property
   * @exception ResourceException Exception raised in failure situation
   * @todo System properties should all use the same resource bundles. Set them.
   */
  public final static StringSingleValueProperty createResourceNameProperty(String value, int propertyFlags)
    throws ResourceException {
    return new StringSingleValueProperty(PropertyName.RESOURCENAME, value, propertyFlags);
  }

  /**
   * Create system property.
   *
   * @param value system property value
   * @param propertyFlags system property flags
   * @return system property
   * @exception ResourceException Exception raised in failure situation
   * @todo System properties should all use the same resource bundles. Set them.
   */
  public final static StringSingleValueProperty createResourceTypeProperty(String value, int propertyFlags)
    throws ResourceException {
    return new StringSingleValueProperty(PropertyName.RESOURCETYPE, value, propertyFlags);
  }

  /**
   * Create system property.
   *
   * @param value system property value
   * @param propertyFlags system property flags
   * @return system property
   * @exception ResourceException Exception raised in failure situation
   * @todo System properties should all use the same resource bundles. Set them.
   */
  public final static DateSingleValueProperty createCreatedProperty(Date value, int propertyFlags)
    throws ResourceException {
    return new DateSingleValueProperty(PropertyType.DATETIME, PropertyName.CREATED, value, propertyFlags);
  }

  /**
   * Create system property.
   *
   * @param value system property value
   * @param propertyFlags system property flags
   * @return system property
   * @exception ResourceException Exception raised in failure situation
   * @todo System properties should all use the same resource bundles. Set them.
   */
  public final static StringSingleValueProperty createCreatedByProperty(String value, int propertyFlags)
    throws ResourceException {
    return new StringSingleValueProperty(PropertyName.CREATEDBY, value, propertyFlags);
  }

  /**
   * Create system property.
   *
   * @param value system property value
   * @param propertyFlags system property flags
   * @return system property
   * @exception ResourceException Exception raised in failure situation
   * @todo System properties should all use the same resource bundles. Set them.
   */
  public final static DateSingleValueProperty createModifiedProperty(Date value, int propertyFlags)
    throws ResourceException {
    return new DateSingleValueProperty(PropertyType.DATETIME, PropertyName.MODIFIED, value, propertyFlags);
  }

  /**
   * Create system property.
   *
   * @param value system property value
   * @param propertyFlags system property flags
   * @return system property
   * @exception ResourceException Exception raised in failure situation
   * @todo System properties should all use the same resource bundles. Set them.
   */
  public final static StringSingleValueProperty createModifiedByProperty(String value, int propertyFlags)
    throws ResourceException {
    return new StringSingleValueProperty(PropertyName.MODIFIEDBY, value, propertyFlags);
  }

  /**
   * Create system property.
   *
   * @param value system property value
   * @param propertyFlags system property flags
   * @return system property
   * @exception ResourceException Exception raised in failure situation
   * @todo System properties should all use the same resource bundles. Set them.
   */
  public final static BooleanSingleValueProperty createCollectionProperty(boolean value, int propertyFlags)
    throws ResourceException {
    return new BooleanSingleValueProperty(PropertyName.COLLECTION, value, propertyFlags);
  }

  /**
   * Create system property.
   *
   * @param value system property value
   * @param propertyFlags system property flags
   * @return system property
   * @exception ResourceException Exception raised in failure situation
   * @todo System properties should all use the same resource bundles. Set them.
   */
  public final static LongSingleValueProperty createLinkTypeProperty(long value, int propertyFlags)
    throws ResourceException {
    return new LongSingleValueProperty(PropertyName.LINKTYPE, value, propertyFlags);
  }

  /**
   * Create system property.
   *
   * @param value system property value
   * @param propertyFlags system property flags
   * @return system property
   * @exception ResourceException Exception raised in failure situation
   * @todo System properties should all use the same resource bundles. Set them.
   */
  public final static BooleanSingleValueProperty createReadOnlyProperty(boolean value, int propertyFlags)
    throws ResourceException {
    return new BooleanSingleValueProperty(PropertyName.READONLY, value, propertyFlags);
  }

  /**
   * Create system property.
   *
   * @param value system property value
   * @param propertyFlags system property flags
   * @return system property
   * @exception ResourceException Exception raised in failure situation
   * @todo System properties should all use the same resource bundles. Set them.
   */
  public final static BooleanSingleValueProperty createHiddenProperty(boolean value, int propertyFlags)
    throws ResourceException {
    return new BooleanSingleValueProperty(PropertyName.HIDDEN, value, propertyFlags);
  }

  /**
   * Create system property.
   *
   * @param value system property value
   * @param propertyFlags system property flags
   * @return system property
   * @exception ResourceException Exception raised in failure situation
   * @todo System properties should all use the same resource bundles. Set them.
   */
  public final static StringSingleValueProperty createDisplayNameProperty(String value, int propertyFlags)
    throws ResourceException {
    return new StringSingleValueProperty(PropertyName.DISPLAYNAME, value, propertyFlags);
  }

  /**
   * Create system property.
   *
   * @param value system property value
   * @param propertyFlags system property flags
   * @return system property
   * @exception ResourceException Exception raised in failure situation
   * @todo System properties should all use the same resource bundles. Set them.
   */
  public final static StringSingleValueProperty createDescriptionProperty(String value, int propertyFlags)
    throws ResourceException {
    return new StringSingleValueProperty(PropertyName.DESCRIPTION, value, propertyFlags);
  }

  /**
   * Create system property.
   *
   * @param value system property value
   * @param propertyFlags system property flags
   * @return system property
   * @exception ResourceException Exception raised in failure situation
   * @todo System properties should all use the same resource bundles. Set them.
   */
  public final static LongSingleValueProperty createContentLengthProperty(long value, int propertyFlags)
    throws ResourceException {
    return new LongSingleValueProperty(PropertyName.CONTENTLENGTH, value, propertyFlags);
  }

  /**
   * Create system property.
   *
   * @param value system property value
   * @param propertyFlags system property flags
   * @return system property
   * @exception ResourceException Exception raised in failure situation
   * @todo System properties should all use the same resource bundles. Set them.
   */
  public final static StringSingleValueProperty createContentTypeProperty(String value, int propertyFlags)
    throws ResourceException {
    return new StringSingleValueProperty(PropertyName.CONTENTTYPE, value, propertyFlags);
  }

  /**
   * Create system property.
   *
   * @param value system property value
   * @param propertyFlags system property flags
   * @return system property
   * @exception ResourceException Exception raised in failure situation
   * @todo System properties should all use the same resource bundles. Set them.
   */
  public final static StringSingleValueProperty createContentEncodingProperty(String value, int propertyFlags)
    throws ResourceException {
    return new StringSingleValueProperty(PropertyName.CONTENTENCODING, value, propertyFlags);
  }

  /**
   * Create system property.
   *
   * @param value system property value
   * @param propertyFlags system property flags
   * @return system property
   * @exception ResourceException Exception raised in failure situation
   * @todo System properties should all use the same resource bundles. Set them.
   */
  public final static StringSingleValueProperty createContentLanguageProperty(String value, int propertyFlags)
    throws ResourceException {
    return new StringSingleValueProperty(PropertyName.CONTENTLANGUAGE, value, propertyFlags);
  }

  /**
   * Create system property.
   *
   * @param value system property value
   * @param propertyFlags system property flags
   * @return system property
   * @exception ResourceException Exception raised in failure situation
   * @todo System properties should all use the same resource bundles. Set them.
   */
  public final static StringSingleValueProperty createETagProperty(String value, int propertyFlags)
    throws ResourceException {
    return new StringSingleValueProperty(PropertyName.ETAG, value, propertyFlags);
  }
}
