/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id$
 */

package com.sap.netweaver.bc.rf.mi.lock;
import com.sap.netweaver.bc.rf.common.*;

import com.sap.netweaver.bc.rf.common.exception.*;

import java.util.*;

/**
 * Read-Only interface describing a repository sub manager for locking.
 * Resources may be locked shallow or deep (in the resource hierarchy), exclusiv
 * or shared (concerning concurrent access) and for reading or writing. Shallow
 * locks affect only the given resource handle (content, properties, etc. and
 * the namespace, not the resources, below the resource), where deep locks
 * effect also the descendents in the resource hierarchy. Exclusive locks block
 * any other lock from being obtained on the given resource handle and block any
 * unlocked access. Shared locks block any exclusive lock from being obtained on
 * the given resource handle and block any unlocked access too, but allow for
 * further shared locks. Write locks are for write access while read locks are
 * for read access. Within the framework, read locks are currently not used.
 *
 * @created 23. Januar 2003
 */
// JRE: locks do NOT block unlocked access when it's read-only
// JRE: AFAIK, we currently have neither (a) use cases nor (b) implementations of read locks

public interface ILockManager {
  /**
   * Get list of {@link ILogInfo} instances describing all locks set for the
   * given resource handle independly of the user. Returns also deep locks of
   * parent resources if set above the given resource. Returns an empty list if
   * no locks are found for the resource.
   *
   * @param resourceHandle resource handle
   * @return The locks value
   * @exception ResourceException when the list of the locks can't be obtained
   */
  public List getLocks(IResourceHandle resourceHandle)
    throws ResourceException;
}
