/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id$
 */

package com.sap.netweaver.bc.rf.mi.content;
import com.sap.netweaver.bc.rf.common.*;

import com.sap.netweaver.bc.rf.common.content.*;
import com.sap.netweaver.bc.rf.common.exception.*;

/**
 * Read-And-Write interface describing a repository sub manager for content.
 * Each resource may provide content modifyable through this interface. Content
 * may be anything implementing the {@link IContent} interface.
 *
 * @created 23. Januar 2003
 */
// JRE: for efficient and atomic updates, a variant with "if-etag-match" would be extremely useful
public interface IMutableContentManager extends IContentManager {
  /**
   * Set content of the resource. The metadata of the content will be updated
   * atomically during the set call if supported by the repository manager (e.g.
   * for etag and last-modified-by timestamp).
   *
   * @param resourceHandle resource handle
   * @param content content
   * @param compareETags when true, the content will only be set, when the
   *      actual entity tag is up-to-date, i.e. the content wasn't modified
   *      between the getContent() and the setContent() call
   * @exception ResourceException when content can't be written
   * @exception ContentMetadataMismatchException when content metadata doesn't
   *      match call or content, e.g. because compareETags is true, but eTag
   *      doesn't match or because content length was specified but doesn't
   *      match with content itself
   */
  public void setContent(IResourceHandle resourceHandle,
    IMutableContent content,
    boolean compareETags)
    throws ResourceException, ContentMetadataMismatchException;
}
