/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id$
 */

package com.sap.netweaver.bc.rf.mi.content;
import com.sap.netweaver.bc.rf.common.*;

import com.sap.netweaver.bc.rf.common.content.*;
import com.sap.netweaver.bc.rf.common.exception.*;

import java.util.*;

/**
 * Read-Only interface describing a repository sub manager for content. Each
 * resource may provide content accessible through this interface. Content may
 * be anything implementing the {@link IContent} interface.
 *
 * @created 23. Januar 2003
 */
// JRE: IContent and IEntityMetadata needs to be consolidated
// JRE: need to consolidate the relationship between metadata and resource properties (such content-language, content-encodign etc...)
// JRE: for efficiency, it would be nice if a condition such as "etag non-match" or "not-modified-since" could be expressed
public interface IContentManager {
  /**
   * Get content of the resource.
   *
   * @param resourceHandle resource handle
   * @return content
   * @exception ResourceException when content can't be read
   */
  public IContent getContent(IResourceHandle resourceHandle)
    throws ResourceException;

  /**
   * Get content of a list of resource handles. If no content is available for a
   * resource, the whole resource isn't stored inside the returned data
   * structure. Returns an empty map if no content is available for all
   * resources. </p> Note: This method needs not to be handled atomically!
   * Although this operation may fail in parts, the operation on one of the many
   * operands provided through the parameter list is always expected to be
   * atomic!
   *
   * @param resourceHandles list of resource handles
   * @return map of content indexed by resource handles
   * @exception ResourceException when a general problem occured
   * @exception OperationNotCompletedException when the operation failed in
   *      parts (either a resource handle was invalid or its content retrieval
   *      failed)
   */
  public Map getContent(List resourceHandles)
    throws ResourceException, OperationNotCompletedException;
}
