/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id$
 */

package com.sap.netweaver.bc.rf.mi.binding;
import com.sap.netweaver.bc.rf.common.*;

import com.sap.netweaver.bc.rf.common.binding.*;
import com.sap.netweaver.bc.rf.common.exception.*;

import java.util.*;

/**
 * TBD: Insufficient description. Read-And-Write interface describing a
 * repository sub manager for bindings. Note: Please do not activate this
 * package as-is, but try to reintegrate it into the namespace package. There
 * are many similar but just temporarily extended interfaces/classes in the
 * common namespace package also.
 *
 * @created 23. Januar 2003
 */
public interface IMutableBindingManager extends IBindingManager {
  /**
   * Create resource based on a resource create descriptor. Default resource
   * create descriptors reside in the same package as the interface does. A
   * repository may supports these and/or others.
   *
   * @param createDescriptor create descriptor
   * @return resource handle of the newly created resource
   * @exception ResourceException when wrong parameterized, the resource create
   *      descriptor is not supported by the repository or the query failed due
   *      to other reasons
   */
  public IResourceHandle createResource(IBindingCreateDescriptor createDescriptor)
    throws ResourceException;

  /**
   * Delete resource. All children will be deleted also, i.e. there is only deep
   * delete. The first returned resource handle must be the deleted root
   * resource handle, if this operation succeeded at all. </p> Note: This method
   * needs not to be handled atomically! Although this operation may fail in
   * parts, the operation on one of the many operands provided through the
   * parameter list is always expected to be atomic!
   *
   * @param resourceHandle resource handle
   * @return list of all deleted resources; resources failed to be deleted
   *      either of repository-internal reasons, follow-up reasons or others are
   *      stored with their respective exception inside the list
   * @exception ResourceException when wrong parameterized or the query failed
   *      due to other reasons
   * @exception OperationNotCompletedException when the operation failed in
   *      parts
   */
  public List deleteResource(IResourceHandle resourceHandle)
    throws ResourceException, OperationNotCompletedException;

  /**
   * Copy resource based on a resource copy descriptor. Default resource copy
   * descriptors reside in the same package as the interface does. A repository
   * may supports these and/or others. The first returned resource handle must
   * be the copied root resource handle, if this operation succeeded at all.
   * </p> Note: This method needs not to be handled atomically! Although this
   * operation may fail in parts, the operation on one of the many operands
   * provided through the parameter list is always expected to be atomic!
   *
   * @param resourceHandle resource handle
   * @param copyDescriptor copy descriptor
   * @return list of all newly created copied resources; resources failed to be
   *      copied either of repository-internal reasons, follow-up reasons or
   *      others are stored with their respective exception inside the list
   * @exception ResourceException when wrong parameterized, the resource copy
   *      descriptor is not supported by the repository or the query failed due
   *      to other reasons
   * @exception OperationNotCompletedException when the operation failed in
   *      parts
   */
  public List copyResource(
    IResourceHandle resourceHandle,
    ICopyDescriptor copyDescriptor)
    throws ResourceException, OperationNotCompletedException;

  /**
   * Move resource based on a resource move descriptor. Default resource move
   * descriptors reside in the same package as the interface does. A repository
   * may supports these and/or others. The first returned resource handle must
   * be the moved root resource handle, if this operation succeeded at all. </p>
   * Note: This method needs not to be handled atomically! Although this
   * operation may fail in parts, the operation on one of the many operands
   * provided through the parameter list is always expected to be atomic!
   *
   * @param resourceHandle resource handle
   * @param moveDescriptor move descriptor
   * @return list of all moved resources; resources failed to be moved either of
   *      repository-internal reasons, follow-up reasons or others are stored
   *      with their respective exception inside the list
   * @exception ResourceException when wrong parameterized, the resource move
   *      descriptor is not supported by the repository or the query failed due
   *      to other reasons
   * @exception OperationNotCompletedException when the operation failed in
   *      parts
   */
  public List moveResource(
    IResourceHandle resourceHandle,
    IMoveDescriptor moveDescriptor)
    throws ResourceException, OperationNotCompletedException;
}
