/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id$
 */

package com.sap.netweaver.bc.rf.mi.binding;
import com.sap.netweaver.bc.rf.common.*;

import com.sap.netweaver.bc.rf.common.exception.*;

import java.util.*;

/**
 * TBD: Insufficient description. Read-Only interface describing a repository
 * sub manager for bindings. Note: Please do not activate this package as-is,
 * but try to reintegrate it into the namespace package. There are many similar
 * but just temporarily extended interfaces/classes in the common namespace
 * package also.
 *
 * @created 23. Januar 2003
 */
public interface IBindingManager {
  /**
   * Get list of bindings of the resource.
   *
   * @param resourceHandle resource handle
   * @return list of RIDs for that resource handle
   * @exception ResourceException when wrong parameterized or the query failed
   *      due to other reasons
   */
  public List getBindings(IResourceHandle resourceHandle)
    throws ResourceException;
}
