/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id$
 */

package com.sap.netweaver.bc.rf.mi;

import com.sap.netweaver.bc.rf.util.exception.*;

/**
 * Abstract class implementing a repository sub manager.
 *
 * @created 21. Februar 2003
 */
public abstract class AbstractSubManager implements ISubManager {
  protected final IManager repositoryManager;

  /**
   * Construct object of class AbstractSubManager.
   *
   * @param repositoryManager repository manager
   */
  protected AbstractSubManager(IManager repositoryManager) {
    this.repositoryManager = repositoryManager;
  }

  /**
   * Will be called by the framework after the repository manager has been
   * started. Can optionally be overwritten in sub manager implementation. This
   * default implementation does nothing.
   *
   * @exception BaseException Exception raised in failure situation
   */
  protected void startUp()
    throws BaseException { }

  /**
   * Will be called by the framework prior to shutting down the repository
   * manager. Can optionally be overwritten in sub manager implementation. This
   * default implementation does nothing.
   */
  protected void shutDown() { }
}
