package com.sapportals.wcm.service.resourceTypeRegistry;

/**
 * Title:        Resource Type Registry
 * Description:  Resource Type Registry
 * Component:    Repository Framework
 * Copyright:    (c) 2003
 * Company:      SAP AG, Walldorf, Germany
 *               All rights reserved.
 * @author       Heiko Kiessling
 * @version      $Id: //kmgmt/bc.rf.global.service/60NW_SP_COR/src/_rtr/java/api/com/sapportals/wcm/service/resourceTypeRegistry/ResourceTypeRegistryServiceFactory.java#3 $
 */

import com.sap.tc.logging.Location;

import com.sapportals.wcm.repository.IResourceFactory;
import com.sapportals.wcm.repository.ResourceFactory;
import com.sapportals.wcm.repository.ResourceException;
import com.sapportals.wcm.service.ServiceFactory;

import com.sapportals.wcm.service.AbstractService;

public class ResourceTypeRegistryServiceFactory {

  static String version = "$Id: //kmgmt/bc.rf.global.service/60NW_SP_COR/src/_rtr/java/api/com/sapportals/wcm/service/resourceTypeRegistry/ResourceTypeRegistryServiceFactory.java#3 $";

  // Name of the ConfigClass of the service
	private final static String                       CFG_CL_RESOURCE_TYPE_REGISTRY = "ResourceTypeRegistryService";
	private       static IResourceTypeRegistryService instance;
	
  /**
   * Gets an instance of the resource type registry service.
   * @return Resource type registry service
   * @throws ResourceException If there was an internal error
   *                           while getting the instance.
   */
  public static IResourceTypeRegistryService getInstance()
	                                                      throws ResourceException {
    return (IResourceTypeRegistryService) ResourceFactory.getInstance().getServiceFactory().getService(CFG_CL_RESOURCE_TYPE_REGISTRY);
  }
}
