package com.sap.engine.examples.javamail.servlet;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Vector;

import javax.mail.Folder;
import javax.mail.Session;
import javax.mail.Store;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

public class ShowNews extends HttpServlet {
	protected void doGet(
		HttpServletRequest request,
		HttpServletResponse response)
		throws ServletException, IOException {
		doPost(request, response);
	}

	protected void doPost(
		HttpServletRequest request,
		HttpServletResponse response)
		throws ServletException, IOException {
		String server = request.getParameter("server").trim();
		response.setContentType("text/html");
		HttpSession sessionHTTP = request.getSession(true);
		PrintWriter out = new PrintWriter(response.getOutputStream());
		out.println("<html>");
		out.println("<head><title>CheckMail</title></head>");
		out.println("<STYLE>");
		out.println(
			"H2 { color: #000000; font-family: \"Verdana\", \"Arial\", \"Helvetica\", \"Sans-serif\"; font-size: 14px }");
		out.println(
			"P { font-family: \"Verdana\", \"Arial\", \"Helvetica\", \"Sans-serif\"; font-size: 12px }");
		out.println("A:visited { color: #FEBD06 }");
		out.println("A:link { color: #FEBD06 }");
		out.println("</STYLE>");
		out.println("<BODY>");
		checkMail(server, sessionHTTP, out);
		out.println("</FONT>");
		out.println("</P></body></html>");
		out.close();
	}

	/**
	 * Gets an NNTPSession object from the DB and using it goes into 
	 * authenticate state for the given POP3_server.
	 *
	 */
	private void checkMail(
		String server,
		HttpSession sessionHTTP,
		PrintWriter out) {
		String str = null;
		Store st = null;
		Folder f = null;
		Folder[] flArr = null;
		try {
			Context ctx = new InitialContext();
			Session session =
				(Session) ctx.lookup("java:comp/env/mail/MailSession");
			st = session.getStore("nntp_get");
			st.connect(server, "", "");
			f = (Folder) st.getDefaultFolder();
		} catch (Exception e) {
			out.println("<CENTER><P>Error during connecting</P>");
			out.println("</CENTER>");
			try {
				st.close();
				f.close(false);
			} catch (Exception ex) {
			}
			return;
		}

		try {
			flArr = f.list("*");
		} catch (Exception e) {
			out.println("<CENTER><P>A News (NNTP) error occurred</P>");
			out.println("<P>" + e.getMessage() + "</P>");
			out.println("</CENTER>");
			try {
				st.close();
				f.close(false);
			} catch (Exception ex) {
			}
			return;
		}

		if (flArr.length == 0) {
			out.println("<CENTER><P>No newsgroups</P>");
			out.println("</CENTER>");
			try {
				st.close();
				f.close(false);
			} catch (Exception e) {
			}
			return;
		}

		InfFolder inf = new InfFolder("NEWSGROUPS", true);
		Vector v = new Vector();
		v.addElement(inf);
		for (int i = 0; i < flArr.length; i++) {
			inf = new InfFolder(flArr[i].getFullName(), false);
			v.addElement(inf);
		}
		out.println("<CENTER><P>Newsgroups<P><BR>");
		out.println("<table  BORDER=0 COLS=1 WIDTH=\"3%\" ALIGN=CENTER>");
		for (int i = 0; i < flArr.length; i++) {
			out.println("<tr>");
			out.println("<td>");
			str = flArr[i].getFullName();
			out.println(
				"<A HREF = \"../servlet/ReadNewsgr?name="
					+ str.trim()
					+ "\" TARGET=\"SecondFrame\">"
					+ str
					+ "</A>"
					+ "<P>");
			out.println("</td>");
			out.println("</tr>");
		}
		out.println("</table>");
		out.println("<BR><BR><BR><BR><BR><BR>");
		out.println("<CENTER>");
		out.println("</CENTER>");
		sessionHTTP.setAttribute("vector", v);
		sessionHTTP.setAttribute("defFolder", f);
		sessionHTTP.setAttribute("store", st);
	}

}
