package com.sap.engine.examples.javamail.servlet;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.Date;

import javax.mail.Address;
import javax.mail.Flags;
import javax.mail.Folder;
import javax.mail.Message;
import javax.mail.Multipart;
import javax.mail.Part;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

public class ShowMessage extends HttpServlet {
	public void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
	  Message m = null;
	  Folder fl = null;
	  Message mes = null;
	  HttpSession sessionHTTP = request.getSession(false);
	  String num = request.getParameter("sub");
    
	  response.setContentType("text/html");
	  PrintWriter out = new PrintWriter (response.getOutputStream());
	  out.println("<html>");
	  out.println("<head><title>CheckMail</title></head>");
	  out.println("<STYLE>");
	  out.println("H2 { color: #000000; font-family: \"Verdana\", \"Arial\", \"Helvetica\", \"Sans-serif\"; font-size: 14px }");
	  out.println("P { font-family: \"Verdana\", \"Arial\", \"Helvetica\", \"Sans-serif\"; font-size: 12px }");
	  out.println("A:visited { color: #FEBD06 }");
	  out.println("A:link { color: #FEBD06 }");
		  out.println("</STYLE>");
		  out.println("<BODY>");
	  out.println("<table border=8 colomn=1 CELLSPACING=30 >");
	  out.println("<tr>");
	  out.println("<td>");
	  out.println("<P><B>Message number: </B> " + num  + "</P>");
	  fl = (Folder)sessionHTTP.getAttribute("folder");
	  try {
		mes  = fl.getMessage(Integer.parseInt(num));
		dumpPart(mes, sessionHTTP, out); 
	  } catch (Exception e) {
		out.println("<CENTER><P>Error during retrieving message from folder</P></CENTER>");
	  }
	  out.println("</td>");
	  out.println("</tr>");
	  out.println("</table>");
	  out.println("</body></html>");
	  out.close();
	}

	/**
	 * The content of the given Part object is sent into the given
	 * PrintWriter stream.
	 *
	 * @param   m  Part object to be transfered
	 * @param   out  PrintWriter in which the content is sent
	 * @exception   Exception  if IOException occurs
	 */
	private void dumpPart(Part m, HttpSession sessionHTTP, PrintWriter out) throws Exception {
	  String res = new String("");
	  int count = 0;
	  int c = 0;
    
	  if (m instanceof Message) {
		dumpEnvelope((Message) m, out);
	  }
	  Object o = m.getContent();             
	  if (m.getFileName() != null) {
		String fileName = m.getFileName();
		String absFileName = (String)sessionHTTP.getAttribute("workDir") + File.separator + fileName;
		File f = new File(absFileName);
		FileOutputStream fos = new FileOutputStream(absFileName);
		if (o instanceof String) {
		  fos.write(((String)o).getBytes());
		} else {
			InputStream in = (InputStream)o; 
		  byte[] buffer = new byte[in.available()];
		  in.read(buffer);
		  fos.write(buffer);
		}
		fos.close();
		File orgFile = new File(absFileName);
		out.println("<P>Attachment:   <A HREF=\"" + "file://" + orgFile.getAbsolutePath() + "\"> " + fileName + "</A> &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; size: " + orgFile.length() + " bytes");
	  } else if (o instanceof String) {
		out.println("<P>" + (String) o);
	  } else if (o instanceof Multipart) {
		Multipart mp = (Multipart)o;
		count = mp.getCount();
		for (int i = 0 ; i < count; i++) {
		  out.println("<HR><P>");
		  dumpPart(mp.getBodyPart(i), sessionHTTP, out);
		}
	  } else if (o instanceof InputStream) {
		InputStream in = (InputStream)o; 
		while ((c = in.read()) != -1) {
		  out.write(c);
		}
	  }
	}
 
  
	/**
	 * The content of the given Message object is sent into the given
	 * PrintWriter stream.
	 *
	 * @param   m  Message object to be transfered
	 * @param   out  PrintWriter in which the content is sent
	 * @exception   Exception  if IOException occurs
	 */
	private void dumpEnvelope(Message m, PrintWriter out) throws Exception {
	  Address[] a = m.getFrom();
	  if (a != null) {
		for (int i = 0; i< a.length; i++) {
		  out.println("<P><B>FROM:</B> " + a[i].toString() + "</P>");
		}
	  }
	  a = m.getRecipients(Message.RecipientType.TO);
	  if (a != null) {
		for (int i = 0; i< a.length; i++) {
		  out.println("<P><B>TO:</B> " + a[i].toString() + "</P>");
		}
	  }
	  out.println("<P><B>SUBJECT:</B> " + m.getSubject() + "</P>");
	  Date d = m.getSentDate();
	  out.println("<P><B>SENT DATE:</B> " + (d !=null ? d.toString() : "unknown") + "</P>");
	  Flags f = m.getFlags();   
	  Flags.Flag [] sf = f.getSystemFlags();
	  out.println("<P><B>FLAGS: </B></P>");
	  if (sf.length == 0) {
		out.println("<P>Flags are not set</P>"); 
	  }
    
	  for (int i = 0; i < sf.length; i++) {
		if (sf[i] == Flags.Flag.DELETED) {
		  out.println("/deleted");
		} else  if (sf[i] == Flags.Flag.SEEN) {
		  out.println("/seen");
		} else  if (sf[i] == Flags.Flag.RECENT) {
		  out.println("/recent");
		} else  if (sf[i] == Flags.Flag.ANSWERED) {
		  out.println("/answered");
		} else  if (sf[i] == Flags.Flag.DRAFT) {
		  out.println("/draft");
		} else  if (sf[i] == Flags.Flag.FLAGGED) {
		  out.println("/flagged");
		} else  if (sf[i] == Flags.Flag.USER) {
		  out.println("/user");
		}
	  }
	  out.println("<hr WIDTH=\"100%\">");
	}

}

