package com.sap.engine.examples.javamail.servlet;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.GregorianCalendar;
import javax.mail.Address;
import javax.mail.Message;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class SendNews extends HttpServlet {
	protected void doGet(
		HttpServletRequest request,
		HttpServletResponse response)
		throws ServletException, IOException {
		doPost(request, response);
	}

	protected void doPost(
		HttpServletRequest request,
		HttpServletResponse response)
		throws ServletException, IOException {
		response.setContentType("text/html");
		PrintWriter out = new PrintWriter(response.getOutputStream());

		String host = request.getParameter("host").trim();
		String to = request.getParameter("group").trim();
		String from = request.getParameter("from").trim();
		String subject = request.getParameter("subject").trim();
		String message = request.getParameter("message").trim();

		if (send(host, from, to, subject, message)) {
			out.println("<html>");
			out.println("<STYLE>");
			out.println(
				"H2 { color: #000000; font-family: \"Verdana\", \"Arial\", \"Helvetica\", \"Sans-serif\"; font-size: 14px }");
			out.println(
				"P { font-family: \"Verdana\", \"Arial\", \"Helvetica\", \"Sans-serif\"; font-size: 12px }");
			out.println("A:visited { color: #FEBD06 }");
			out.println("A:link { color: #FEBD06 }");
			out.println("</STYLE>");
			out.println("<BODY>");
			out.println("<P><CENTER> Your news was successfully sent.</P>");
			out.println("</CENTER></P>");
			out.println("</body></html>");
			out.close();
		} else {
			out.println("<html>");
			out.println("<STYLE>");
			out.println(
				"H2 { color: #000000; font-family: \"Verdana\", \"Arial\", \"Helvetica\", \"Sans-serif\"; font-size: 14px }");
			out.println(
				"P { font-family: \"Verdana\", \"Arial\", \"Helvetica\", \"Sans-serif\"; font-size: 12px }");
			out.println("A:visited { color: #FEBD06 }");
			out.println("A:link { color: #FEBD06 }");
			out.println("</STYLE>");
			out.println("<BODY>");
			out.println("<P><CENTER> Your news could not be sent.</P>");
			out.println("</CENTER>");
			out.println("</body></html>");
			out.close();
		}
	}

	/**
	 * Private method used to send the given Message object.
	 *
	 * @return     true if sending is successful; false otherwise
	 */
	private boolean send(
		String host,
		String from,
		String to,
		String subject,
		String message) {

		try {
			Context ctx = new InitialContext();
			Session sess =
				(Session) javax.rmi.PortableRemoteObject.narrow(
					ctx.lookup("java:comp/env/mail/MailSession"),
					Session.class);
			Message msg = new MimeMessage(sess);
			msg.setSubject(subject);
			msg.setContent(message, "text/plain");
			msg.setSentDate(new GregorianCalendar().getTime());
			msg.setFrom(new InternetAddress(from));
			msg.setHeader("Newsgroups", to);
			msg.saveChanges();
			Transport tr = sess.getTransport("nntp_put");
			tr.connect(host, "", "");
			Address[] address = new Address[0];
			tr.sendMessage(msg, address);
			tr.close();
		} catch (Exception e) {
			return false;
		}

		return true;
	}

}
