package com.sap.engine.examples.javamail.servlet;
import java.io.IOException;
import java.io.PrintWriter;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.naming.*;
import com.sap.engine.examples.ejb.javamail.*;

public class SendMailUsingEJB extends HttpServlet {
	protected void doGet(
		HttpServletRequest request,
		HttpServletResponse response)
		throws ServletException, IOException {
		doPost(request, response);
	}

	protected void doPost(
		HttpServletRequest request,
		HttpServletResponse response)
		throws ServletException, IOException {
		response.setContentType("text/html");
		PrintWriter out = new PrintWriter(response.getOutputStream());
		out.println("<html>");
		out.println("<head><title>Send mail using EJB demo</title>");
		out.println(
			"<SCRIPT LANGUAGE=JavaScript><!--Begin Cloaking\nfunction ChangeStatus(Message){window.status = Message; window.title = Message; return true}\n// End Cloaking --></SCRIPT></head>");
		out.println("<STYLE>");
		out.println(
			"H2 { color: #000000; font-family: \"Verdana\", \"Arial\", \"Helvetica\", \"Sans-serif\"; font-size: 14px }");
		out.println(
			"P { font-family: \"Verdana\", \"Arial\", \"Helvetica\", \"Sans-serif\"; font-size: 12px }");
		out.println("A:visited { color: #FEBD06 }");
		out.println("A:link { color: #FEBD06 }");
		out.println("</STYLE>");
		out.println("<BODY>");
		out.println("<pre>");

		try {
			InitialContext initialContext = new InitialContext();
			SendMailLocalHome sendMailHome =
				(SendMailLocalHome) javax.rmi.PortableRemoteObject.narrow(
					initialContext.lookup("java:comp/env/SendMail"),
					SendMailLocalHome.class);
			SendMailLocal sendMail = sendMailHome.create();

			out.println(
				"<P><CENTER> Trying to send your email...</CENTER></P>");
			out.println(
				"<SCRIPT LANGUAGE=JavaScript><!--Begin Cloaking\n ChangeStatus(\'Trying to send your email...\')\n// End Cloaking --></SCRIPT>");
			out.flush();

			sendMail.setHost(request.getParameter("SMTP").trim());
			sendMail.setFrom(request.getParameter("from").trim());
			sendMail.setTo(request.getParameter("to").trim());
			sendMail.setSubject(request.getParameter("subject").trim());
			sendMail.setMessages(request.getParameterValues("message"));

			String attachedFileName = request.getParameter("attachment");
			// attached file name can be null if called from 
			// the web form offering no attachment capabilities
			if (attachedFileName != null) {
				attachedFileName = attachedFileName.trim();
			}
			sendMail.setAttachedFileName(attachedFileName);

			sendMail.send();
			out.println(
				"<P><CENTER>Your mail was successfully sent to all the recipients</CENTER></P>");

		} catch (Exception e) {
			//StringWriter strWr = new StringWriter();
			e.printStackTrace();
			//out.println("<P><CENTER>Your mail could not be send because of an error. </P><br><pre>"+ strWr.getBuffer() + "</pre><br>");
			out.println(
				"<P><CENTER>Your mail could not be send because of an error. </P>");
			out.println(
				"<P>Check the information you submitted and try again.</P></CENTER>");
		}

		out.println("</body></html>");
		out.close();

	}

}
