package com.sap.engine.examples.javamail.servlet;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.GregorianCalendar;
import java.util.StringTokenizer;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.activation.DataHandler;
import javax.activation.FileDataSource;
import javax.mail.*;
import javax.mail.internet.*;
import javax.naming.InitialContext;

public class SendMail extends HttpServlet {
	protected void doGet(
		HttpServletRequest request,
		HttpServletResponse response)
		throws ServletException, IOException {
		doPost(request, response);
	}

	protected void doPost(
		HttpServletRequest request,
		HttpServletResponse response)
		throws ServletException, IOException {
		PrintWriter out = null;
		response.setContentType("text/html");
		out = new PrintWriter(response.getOutputStream());
		out.println("<html>");
		out.println("<head><title>Send mail demo</title>");
		out.println(
			"<SCRIPT LANGUAGE=JavaScript><!--Begin Cloaking\nfunction ChangeStatus(Message){window.status = Message; window.title = Message; return true}\n// End Cloaking --></SCRIPT></head>");
		out.println("<STYLE>");
		out.println(
			"H2 { color: #000000; font-family: \"Verdana\", \"Arial\", \"Helvetica\", \"Sans-serif\"; font-size: 14px }");
		out.println(
			"P { font-family: \"Verdana\", \"Arial\", \"Helvetica\", \"Sans-serif\"; font-size: 12px }");
		out.println("A:visited { color: #FEBD06 }");
		out.println("A:link { color: #FEBD06 }");
		out.println("</STYLE>");
		out.println("<BODY>");

		out.println("<P><CENTER>Trying to send your email...");
		out.println(
			"<SCRIPT LANGUAGE=JavaScript><!--Begin Cloaking\n ChangeStatus(\'Trying to send your email...\')\n// End Cloaking --></SCRIPT>");
		out.flush();

		String host = request.getParameter("SMTP").trim();
		String from = request.getParameter("from").trim();
		String to = request.getParameter("to").trim();
		String subject = request.getParameter("subject").trim();
		String[] messages = request.getParameterValues("message");

		String attachedFileName = request.getParameter("attachment");
		// attached file name can be null if called from 
		// the web form offering no attachment capabilities
		if (attachedFileName != null) {
			attachedFileName = attachedFileName.trim();
		}

		if (send(host, from, to, subject, messages, attachedFileName)) {
			out.println(
				"<P>Your mail was successfully sent to all recipients</P></CENTER>");
			out.println(
				"<SCRIPT LANGUAGE=JavaScript><!--Begin Cloaking\n ChangeStatus(\'Your mail was successfully sent all recipients\')\n// End Cloaking --></SCRIPT>");
			out.println("</body></html>");
			out.close();
		} else {
			out.println(
				"<P>Your mail could not be send because of an error.</P>");
			out.println(
				"<SCRIPT LANGUAGE=JavaScript><!--Begin Cloaking\n ChangeStatus(\'Your mail could not be send because of an error.\')\n// End Cloaking --></SCRIPT>");
			out.println(
				"<P>Check the information you submitted and try again.</P></CENTER>");
			out.println("</body></html>");
			out.close();
		}
	}

	/**
	 * Private method used to send the given Message object.
	 *
	 * @return     true if sending is successful; false otherwise
	 */
	private boolean send(
		String host,
		String from,
		String to,
		String subject,
		String[] messages,
		String attachedFileName) {
		Address[] address = null;

		Multipart mp = null;
		Transport tr = null;
		Session sess = null;

		try {
			InitialContext ctx = new InitialContext();
			sess =
				(Session) javax.rmi.PortableRemoteObject.narrow(
					ctx.lookup("java:comp/env/mail/MailSession"),
					Session.class);
			Message msg = new MimeMessage(sess);
			msg.setFrom(new InternetAddress(from));
			msg.setRecipients(
				Message.RecipientType.TO,
				extractRecipientAddresses(to));
			msg.setSubject(subject);
			boolean hasAttachment =
				(attachedFileName != null) && (attachedFileName.length() > 0);
			boolean isMultiPart = (messages != null) && (messages.length > 1);

			// adding an attachment makes the message multipart 
			if (isMultiPart || hasAttachment) {
				mp = new MimeMultipart();

				// add text parts
				if (messages != null) {
					for (int i = 0; i < messages.length; i++) {
						MimeBodyPart bodyPart = new MimeBodyPart();
						bodyPart.setContent(messages[i], "text/plain");
						mp.addBodyPart(bodyPart);
					}
				}

				// attach the file to the message if needed
				if (hasAttachment) {
					// avoid the case with no text parts
					MimeBodyPart bodyPart = new MimeBodyPart();
					bodyPart.setContent("Attachment enclosed.", "text/plain");
					mp.addBodyPart(bodyPart);
					// the part with the file
					FileDataSource fds = new FileDataSource(attachedFileName);
					MimeBodyPart attachmentBodyPart = new MimeBodyPart();
					attachmentBodyPart.setDataHandler(new DataHandler(fds));
					attachmentBodyPart.setFileName(fds.getName());
					mp.addBodyPart(attachmentBodyPart);
				}
				msg.setContent(mp);
			} else {
				if ((messages != null) && (messages.length > 0)) {
					msg.setContent(messages[0], "text/plain");
				} else {
					msg.setContent("", "text/plain");
				}
			}

			msg.setSentDate(new GregorianCalendar().getTime());
			msg.saveChanges();
			tr = sess.getTransport("smtp");
			tr.connect(host, "", "");
			address = msg.getAllRecipients();
			tr.sendMessage(msg, address);
			tr.close();
		} catch (Exception e) {
			return false;
		}
		return true;
	}

	/**
	 * Converts the given String object to an array of InternetAddress 
	 * objects containing the addresses kept in the given String object.
	 *
	 * @param   str  String object which keeps addresses of the message to be send
	 * @return       the converted InternetAddress objects
	 */
	private InternetAddress[] extractRecipientAddresses(String str) {
		StringTokenizer st = new StringTokenizer(str, " ;,:");
		InternetAddress[] rcpt = new InternetAddress[st.countTokens()];

		try {
			for (int i = 0; i < rcpt.length; i++) {
				rcpt[i] = new InternetAddress(st.nextToken());
			}
		} catch (Exception e) {
			return new InternetAddress[0];
		}

		return rcpt;
	}

}
