package com.sap.engine.examples.javamail.servlet;
import java.io.IOException;
import java.io.PrintWriter;
import javax.servlet.ServletException;
import javax.servlet.http.*;
import javax.mail.*;
import javax.naming.Context;
import javax.naming.InitialContext;

public class RetrieveMailPOP3 extends HttpServlet {
	protected void doGet(
		HttpServletRequest request,
		HttpServletResponse response)
		throws ServletException, IOException {
		doPost(request, response);
	}

	protected void doPost(
		HttpServletRequest request,
		HttpServletResponse response)
		throws ServletException, IOException {
		Folder fl = null;
		Store st = null;
		String pop3Server = request.getParameter("server").trim();
		String userName = request.getParameter("user").trim();
		String password = request.getParameter("pass").trim();
		response.setContentType("text/html");
		HttpSession sessionHTTP = request.getSession(true);
		sessionHTTP.setMaxInactiveInterval(20);
		fl = (Folder) sessionHTTP.getAttribute("folder");
		st = (Store) sessionHTTP.getAttribute("store");
		try {
			if (fl != null) {
				fl.close(false);
			}
			if (st != null) {
				st.close();
			}
		} catch (Exception e) {
		}
		sessionHTTP.invalidate();
		sessionHTTP = request.getSession(true);
		PrintWriter out = new PrintWriter(response.getOutputStream());
		out.println("<html>");
		out.println("<head><title>CheckMail</title></head>");
		out.println("<STYLE>");
		out.println(
			"H2 { color: #000000; font-family: \"Verdana\", \"Arial\", \"Helvetica\", \"Sans-serif\"; font-size: 14px }");
		out.println(
			"P { font-family: \"Verdana\", \"Arial\", \"Helvetica\", \"Sans-serif\"; font-size: 12px }");
		out.println("A:visited { color: #FEBD06 }");
		out.println("A:link { color: #FEBD06 }");
		out.println("</STYLE>");
		out.println("<BODY>");
		checkMail(pop3Server, userName, password, out, sessionHTTP);
		out.println("</body></html>");
		out.close();
	}

	/**
	 * Gets an POP3Session object from the DB and using it goes into 
	 * authenticate state for the given POP3_server.
	 *
	 */
	private void checkMail(
		String pop3Server,
		String userName,
		String password,
		PrintWriter out,
		HttpSession sessionHTTP) {
		Message msg = null;
		Session session = null;
		Folder fl = null;
		Folder f = null;
		Store st = null;
		Context ctx = null;
		int k = 0;
		int cn = 0;

		try {
			ctx = new InitialContext();
			session =
				(Session) javax.rmi.PortableRemoteObject.narrow(
					ctx.lookup("java:comp/env/mail/MailSession"),
					Session.class);
		} catch (Exception e) {
			e.printStackTrace();
		}

		String workDir = null;
		try {
			st = session.getStore("pop3");
			st.connect(pop3Server, userName, password);
			workDir = session.getProperty("workDir");
			f = st.getDefaultFolder();
			fl = f.getFolder("INBOX");
		} catch (Exception e) {
			e.printStackTrace();
			out.println(
				"<P><CENTER>Error during connecting: <P>"
					+ ((e.getMessage() == null) ? " " : e.getMessage())
					+ "<P>");
			out.println("</CENTER></P>");
			out.println("</body></html>");
			out.close();
			return;
		}

		out.println("<P><CENTER>Retrieve mail using POP3 protocol<P>");

		try {
			fl.open(Folder.READ_ONLY);
		} catch (Exception e) {
			out.println("<P>Can't open folder</P>");
			return;
		}
		try {
			k = fl.getMessageCount();
			if (k == 0) {
				out.println("<P>No messages in folder</P>");
				return;
			}
			out.println("<P>Messages in INBOX: " + k + "</P>");
			out.println(
				"<P><FORM ACTION=\"../servlet/GetMessages\" METHOD=POST TARGET=\"SecondFrame\">");
			out.println(
				"<INPUT TYPE=\"hidden\" NAME=\"maxCount\" VALUE=\""
					+ k
					+ "\" SIZE=4 MAXLENGTH=4></P>");
		} catch (Exception e) {
			e.printStackTrace();
			out.println("<P>Error in getMessageCount() method</P>");
			return;
		}

		out.println("<P>Retrieve messages from:");
		out.println(
			"<INPUT TYPE=\"text\" NAME=\"beginInd\" VALUE=\"1\" SIZE=4 MAXLENGTH=4></P>");
		out.println("<P> To: ");
		out.println(
			"<INPUT TYPE=\"text\" NAME=\"lastInd\" VALUE= \""
				+ k
				+ "\"SIZE=4 MAXLENGTH=4></P>");
		out.println("<P>");
		out.println("<INPUT TYPE=\"submit\" VALUE=\"Retrieve\" ></FORM></P>");
		out.println("<BR><BR><BR><BR>");

		try {
			out.println(
				"<P><table BORDER=1 COLS=2 WIDTH=\"60%\" ALIGN=CENTER>");
			out.println("<tr>");
			out.println("<td>");
			out.println("<CENTER><B>SUBJECT</B></CENTER>");
			out.println("</td>");
			out.println("<td>");
			out.println("<CENTER><B>FROM</B></CENTER>");
			out.println("</td>");
			out.println("</tr>");
			out.println("<tr>");
			out.println("<td>");
			cn = fl.getMessageCount();

			if (cn > 7) {
				cn = 7;
			}

			for (int i = 0; i < cn; i++) {
				msg = fl.getMessage(i + 1);
				out.println(
					"<A HREF = \"../servlet/ShowMessage?sub="
						+ (i + 1)
						+ "\" TARGET=\"SecondFrame\">"
						+ msg.getHeader("Subject")[0]
						+ "</A>");
				out.println("</td>");
				out.println("<td>");
				out.println(msg.getHeader("From")[0]);
				out.println("</td>");
				out.println("</tr>");
				out.println("<tr>");
				out.println("<td>");
			}

			out.println("</td>");
			out.println("</tr>");
			out.println("</table></P>");

			sessionHTTP.setAttribute("workDir", workDir);
			sessionHTTP.setAttribute("folder", fl);
			sessionHTTP.setAttribute("store", st);
		} catch (Exception e) {
			e.printStackTrace();
			out.println("<P>Error in retrieving message</P>");
			return;
		}
	}

}
