package com.sap.engine.examples.javamail.servlet;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Vector;
import javax.servlet.ServletException;
import javax.servlet.http.*;
import javax.mail.*;
import javax.naming.Context;
import javax.naming.InitialContext;

public class RetrieveMailIMAP4 extends HttpServlet {
	protected void doGet(
		HttpServletRequest request,
		HttpServletResponse response)
		throws ServletException, IOException {
			doPost(request, response);
	}

	protected void doPost(
		HttpServletRequest request,
		HttpServletResponse response)
		throws ServletException, IOException {
		Folder fl = null;
		Store st = null;

		String imap4Server = request.getParameter("server");
		String userName = request.getParameter("user");
		String password = request.getParameter("pass");
		response.setContentType("text/html");
		HttpSession sessionHTTP = request.getSession(true);
		fl = (Folder) sessionHTTP.getAttribute("defFolder");
		st = (Store) sessionHTTP.getAttribute("store");
		try {
			if (fl != null) {
				fl.close(false);
			}
			if (st != null) {
				st.close();
			}
		} catch (Exception e) {
		}

		sessionHTTP.invalidate();
		sessionHTTP = request.getSession(true);
		PrintWriter out = new PrintWriter(response.getOutputStream());
		out.println("<html>");
		out.println("<head><title>CheckMail</title></head>");
		out.println("<STYLE>");
		out.println(
			"H2 { color: #000000; font-family: \"Verdana\", \"Arial\", \"Helvetica\", \"Sans-serif\"; font-size: 14px }");
		out.println(
			"P { font-family: \"Verdana\", \"Arial\", \"Helvetica\", \"Sans-serif\"; font-size: 12px }");
		out.println("A:visited { color: #FEBD06 }");
		out.println("A:link { color: #FEBD06 }");
		out.println("</STYLE>");
		out.println("<BODY>");

		checkMail(imap4Server, userName, password, sessionHTTP, out);
		out.println("</body></html>");
		out.close();
	}

	/**
	 * Gets an IMAP4Session object from the DB and using it goes into 
	 * authenticate state for the given IMAP4_server.
	 */
	private void checkMail(
		String imap4Server,
		String userName,
		String password,
		HttpSession sessionHTTP,
		PrintWriter out) {
		Folder f = null;
		Store st = null;
		Folder[] flArr = new Folder[0];
		Vector v = new Vector();
		Session session = null;
		Context ctx = null;
		InfFolder inf = null;

		try {
			ctx = new InitialContext();
			session =
				(Session) javax.rmi.PortableRemoteObject.narrow(
					ctx.lookup("java:comp/env/mail/MailSession"),
					Session.class);
		} catch (Exception e) {
			e.printStackTrace();
		}

		String workDir = null;
		try {
			st = session.getStore("imap4");
			workDir = session.getProperty("workDir");
			st.connect(imap4Server, userName, password);
			f = st.getDefaultFolder();
		} catch (Exception e) {
			out.println(
				"<P><CENTER>Error during connecting! Wrong username or password.</P>");
			out.println("</body></html>");
			out.close();
			return;
		}

		try {
			flArr = f.list("*");
		} catch (Exception e) {
			e.printStackTrace();
			out.println("<P><CENTER>Error during getting Folder Object!</P>");
			out.println("</body></html>");
			out.close();
			return;
		}

		if (flArr.length == 0) {
			out.println("<P><CENTER>This user has no folders! <P>");
			out.println("</body></html>");
			out.close();
			return;
		}

		inf = new InfFolder(f.getFullName(), true);
		v.addElement(inf);
		for (int i = 0; i < flArr.length; i++) {
			inf = new InfFolder(flArr[i].getFullName(), false);
			v.addElement(inf);
		}
		out.println("<BR><BR><BR>");
		out.println(
			"<P><table  BORDER=0 ALIGN=\"center\" COLS=1 WIDTH=\"3%\" ");
		for (int i = 0; i < flArr.length; i++) {
			out.println("<tr>");
			out.println("<td ALIGN=\"center\">");
			String str = flArr[i].getFullName();
			out.println(
				"<A HREF = \"../servlet/GetSubfolder?name="
					+ str.trim()
					+ "\" TARGET=\"FirstFrame\">"
					+ str
					+ "</A>"
					+ "<P>");
			out.println("</td>");
			out.println("</tr>");
		}

		out.println("</table></P>");
		out.println("<CENTER>");
		out.println("<BR><BR><BR><BR>");
		out.println("</CENTER>");

		sessionHTTP.setAttribute("workDir", workDir);
		sessionHTTP.setAttribute("vector", v);
		sessionHTTP.setAttribute("defFolder", f);
		sessionHTTP.setAttribute("store", st);
	}

}
