package com.sap.engine.examples.javamail.servlet;
import java.io.IOException;

import javax.servlet.ServletException;
import javax.servlet.http.*;
import javax.mail.*;
import java.io.PrintWriter;

public class OpenFolder extends HttpServlet {

	public void service(
		HttpServletRequest request,
		HttpServletResponse response)
		throws ServletException, IOException {
		HttpSession sessionHTTP = request.getSession(false);
		String name = "";
		PrintWriter out = null;
		Folder fl = null;
		Folder[] flArr = new Folder[0];
		String beginStr = "1";
		String lastStr = "10";
		boolean holdsOnlyFolders = false;
		int k = 0;

		name = request.getParameter("name");
		if (name != null) {
			name = name.trim();
		}
		response.setContentType("text/html");
		out = new PrintWriter(response.getOutputStream());
		out.println("<html>");
		out.println("<head><title>CheckMail</title></head>");
		out.println("<STYLE>");
		out.println(
			"H2 { color: #000000; font-family: \"Verdana\", \"Arial\", \"Helvetica\", \"Sans-serif\"; font-size: 14px }");
		out.println(
			"P { font-family: \"Verdana\", \"Arial\", \"Helvetica\", \"Sans-serif\"; font-size: 12px }");
		out.println("A:visited { color: #FEBD06 }");
		out.println("A:link { color: #FEBD06 }");
		out.println("</STYLE>");
		out.println("<BODY>");
		fl = (Folder) sessionHTTP.getAttribute("defFolder");
		try {
			fl = fl.getFolder(name);
			flArr = fl.list("%");
		} catch (MessagingException e) {
			out.println("<P>Error during getting Folder Object</P>");
			out.println("</body></html>");
			out.close();
			return;
		}
		try {
			holdsOnlyFolders = (fl.getType() == Folder.HOLDS_FOLDERS);
		} catch (MessagingException e) {
		}
		if (holdsOnlyFolders) {
			out.println(
				"<H2><CENTER>Folder doesn't hold messages</CENTER></H2>");
			out.println("</body></html>");
			out.close();
			return;
		} else {
			try {
				fl.open(Folder.READ_ONLY);
				sessionHTTP.setAttribute("folder", fl);
				k = fl.getMessageCount();
				if (k == 0) {
					out.println(
						"<P><CENTER>No messages in folder</CENTER></P>");
					out.println("</body></html>");
					out.close();
					return;
				}
				out.println(
					"<P><CENTER>Messages in   "
						+ name
						+ " "
						+ k
						+ "</CENTER></P>");
				out.println(
					"<P><FORM ACTION=\"../servlet/GetMessages\" METHOD=POST TARGET=\"SecondFrame\">");
				out.println(
					"<INPUT TYPE=\"hidden\" NAME=\"maxCount\" VALUE=\""
						+ k
						+ "\" SIZE=4 MAXLENGTH=4></P>");
			} catch (Exception e) {
				out.println("<P>Error in getMessageCount() method</P>");
				out.println("</body></html>");
				out.close();
				return;
			}
			if (k < 10) {
				lastStr = String.valueOf(k);
			}
			out.println("<P><CENTER>Retrieve messages from:</P>");
			out.println(
				"<P><INPUT TYPE=\"text\" NAME=\"beginInd\" VALUE="
					+ beginStr
					+ " SIZE=4 MAXLENGTH=4></P>");
			out.println("<P>To:");
			out.println(
				"<P><INPUT TYPE=\"text\" NAME=\"lastInd\" VALUE="
					+ lastStr
					+ " SIZE=4 MAXLENGTH=4></P>");
			out.println(
				"<P><INPUT TYPE=\"submit\" VALUE=\"Retrieve\" ></P></FORM></CENTER>");
			out.println("<BR><BR><BR><BR>");
			out.println(
				"<P><table BORDER=1 COLS=2 WIDTH=\"60%\" ALIGN=CENTER>");
			out.println("<tr>");
			out.println("<td>");
			out.println("<CENTER><B>MAILBOX</B></CENTER>");
			out.println("</td>");
			out.println("</tr>");
			if (k > 10) {
				k = 10;
			}
			for (int i = 1; i <= k; i++) {
				out.println("<tr>");
				out.println("<td>");
				out.println(
					"<A HREF = \"../servlet/ShowMessage?sub="
						+ i
						+ "\" TARGET=\"SecondFrame\"> Message "
						+ i
						+ "</A>");
				out.println("</td>");
				out.println("</tr>");
			}
			out.println("</table></P>");
		}
		out.println("</body></html>");
		out.close();
	}
}
