package com.sap.engine.examples.javamail.servlet;
import java.io.IOException;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.PrintWriter;

public class MultiMessageForm extends HttpServlet {
	protected void doGet(
		HttpServletRequest request,
		HttpServletResponse response)
		throws ServletException, IOException {
		doPost(request, response);
	}

	protected void doPost(
		HttpServletRequest request,
		HttpServletResponse response)
		throws ServletException, IOException {
		response.setContentType("text/html");
		PrintWriter out = new PrintWriter(response.getOutputStream());

		boolean supportAttachments =
			Boolean
				.valueOf(request.getParameter("supportAttachments"))
				.booleanValue();
		int textPartsCount = 1;
		try {
			textPartsCount =
				Integer
					.valueOf(request.getParameter("textPartsCount"))
					.intValue();
		} catch (Exception e) {
		}

		out.println("<html>");
		out.println("<STYLE>");
		out.println(
			"H2 { color: #000000; font-family: \"Verdana\", \"Arial\", \"Helvetica\", \"Sans-serif\"; font-size: 14px }");
		out.println(
			"P { font-family: \"Verdana\", \"Arial\", \"Helvetica\", \"Sans-serif\"; font-size: 12px }");
		out.println("A:visited { color: #FEBD06 }");
		out.println("A:link { color: #FEBD06 }");
		out.println("</STYLE>");
		out.println("<BODY>");
		out.println("<CENTER><H2>Sending mail using SMTP protocol</H2>");
		out.println("<FORM ACTION=\"SendMail\" METHOD=POST>");
		out.println(
			"&nbsp<P> SMTP host: &nbsp <INPUT TYPE=\"text\" NAME=\"SMTP\"  SIZE=40 MAXLENGTH=40></P>");
		out.println(
			"&nbsp<P> From: &nbsp &nbsp &nbsp &nbsp &nbsp <INPUT TYPE=\"text\" NAME=\"from\" SIZE=40 MAXLENGTH=40></P>");
		out.println(
			"&nbsp<P> Recipient: &nbsp &nbsp <INPUT TYPE=\"text\" NAME=\"to\"  SIZE=40 MAXLENGTH=40></P>");
		out.println(
			"&nbsp<P> Subject: &nbsp &nbsp &nbsp <INPUT TYPE=\"text\" NAME=\"subject\" VALUE=\"Message\" SIZE=40 MAXLENGTH=40></P>");
		for (int i = 0; i < textPartsCount; i++) {
			out.println("<P>BodyPart " + (i + 1) + ": ");
			out.println("<TEXTAREA NAME=\"message\" ROWS=\"4\" COLS=\"38\">");
			out.println("BodyPart #" + (i + 1));
			out.println("</TEXTAREA></P>");
		}
		if (supportAttachments) {
			out.println("&nbsp &nbsp <P>Attach:");
			out.println(
				"<INPUT TYPE=\"file\" NAME=\"attachment\" SIZE=40> </P>");
		}
		out.println("<P><INPUT TYPE=\"submit\" VALUE=\"Send\">  ");
		out.println("<INPUT TYPE=\"reset\" VALUE=\"Reset\"></P></CENTER>");
		out.println("</FORM></BODY></html>");
		out.close();
	}

}
