package com.sap.engine.examples.javamail.servlet;
import java.io.IOException;

import javax.servlet.ServletException;
import javax.servlet.http.*;
import javax.mail.*;
import java.io.*;
import java.util.*;

public class GetSubfolder extends HttpServlet {

	public void service(
		HttpServletRequest request,
		HttpServletResponse response)
		throws ServletException, IOException {
		HttpSession sessionHTTP = request.getSession(false);
		Folder fl = null;
		Folder f = null;
		Folder[] flArr = new Folder[0];
		InfFolder inf = null;
		String fn = null;
		String name = request.getParameter("name").replace('\\', '/');
		Store st = (Store) sessionHTTP.getAttribute("store");

		response.setContentType("text/html");
		PrintWriter out = new PrintWriter(response.getOutputStream());
		out.println("<html>");
		out.println("<STYLE>");
		out.println(
			"H2 { color: #000000; font-family: \"Verdana\", \"Arial\", \"Helvetica\", \"Sans-serif\"; font-size: 14px }");
		out.println(
			"P { font-family: \"Verdana\", \"Arial\", \"Helvetica\", \"Sans-serif\"; font-size: 12px }");
		out.println("A:visited { color: #FEBD06 }");
		out.println("A:link { color: #FEBD06 }");
		out.println("</STYLE>");
		out.println("<BODY>");
		Vector v = (Vector) sessionHTTP.getAttribute("vector");
		try {
			f = (Folder) sessionHTTP.getAttribute("defFolder");
			fl = (Folder) f.getFolder(name);
			flArr = (Folder[]) fl.list();
		} catch (Exception e) {
		}
		if (flArr.length != 0) {
			for (int i = 0; i < v.size(); i++) {
				inf = (InfFolder) v.elementAt(i);
				if (inf.fullName.equals(name)) {
					inf.changeOpenFlag();
					v.setElementAt(inf, i);
					break;
				}
			}
			sessionHTTP.setAttribute("vector", v);
		}
		out.println(
			"<H2><CENTER> Retrieve mail using IMAP4 protocol</H2><BR><BR>");
		out.println(
			"<P><FORM ACTION=\"../servlet/OpenFolder\" TARGET=\"SecondFrame\" METHOD=\"POST\">");
		out.println(
			"<INPUT TYPE=\"text\" NAME=\"name\" VALUE="
				+ name
				+ " SIZE=15 MAXLENGTH=40>");
		out.println("<INPUT TYPE=\"submit\" VALUE=\"GetMsg\">");
		paintFolder(f, v, out);
		out.println("</CENTER>");
		out.println("</body>");
		out.close();
	}

	/**
	 * Paints HTML page containing subfolders of the given Filder object.
	 *
	 * @param   f  Folder object
	 */
	private void paintFolder(Folder f, Vector v, PrintWriter out) {
		Folder[] flArr = null;
		InfFolder inf = new InfFolder(f.getFullName(), true);
		for (int i = 0; i < v.size(); i++) {
			inf = (InfFolder) v.elementAt(i);
			if (inf.fullName.equals(f.getFullName())) {
				break;
			}
		}

		try {
			if (inf.isOpen) {
				if (!inf.fullName.equals("")) {
					out.println(
						"<A HREF = \"../servlet/GetSubfolder?name="
							+ inf.fullName
							+ "\" TARGET=\"FirstFrame\">"
							+ f.getName()
							+ "</A>"
							+ "<BR>");
				}

				flArr = f.list("%");
				out.println("<dir>");
				for (int j = 0; j < flArr.length; j++) {
					paintFolder(flArr[j], v, out);
				}
				out.println("</dir>");
			} else {
				out.println(
					"<A HREF = \"../servlet/GetSubfolder?name="
						+ inf.fullName
						+ "\" TARGET=\"FirstFrame\">"
						+ f.getName()
						+ "</A>"
						+ "<BR>");
			}
		} catch (Exception e) {
		}
	}

}
