package com.sap.engine.examples.javamail.servlet;
import java.io.IOException;

import javax.servlet.ServletException;
import javax.servlet.http.*;
import javax.mail.*;
import java.io.PrintWriter;
import java.io.InputStream;
import java.util.Date;

public class GetNextNews extends HttpServlet {
	public void service(
		HttpServletRequest request,
		HttpServletResponse response)
		throws ServletException, IOException {
		HttpSession sessionHTTP = request.getSession(false);
		PrintWriter out = null;
		Message mes;
		Folder fl = null;
		int count = 0;

		fl = (Folder) sessionHTTP.getAttribute("folder");
		response.setContentType("text/html");
		out = new PrintWriter(response.getOutputStream());
		out.println("<html>");
		out.println("<head><title>ShowNews</title></head>");
		out.println("<STYLE>");
		out.println(
			"H2 { color: #000000; font-family: \"Verdana\", \"Arial\", \"Helvetica\", \"Sans-serif\"; font-size: 14px }");
		out.println(
			"P { font-family: \"Verdana\", \"Arial\", \"Helvetica\", \"Sans-serif\"; font-size: 12px }");
		out.println("A:visited { color: #FEBD06 }");
		out.println("A:link { color: #FEBD06 }");
		out.println("</STYLE>");
		out.println("<BODY>");
		try {
			count = fl.getMessageCount();
			out.println(
				"<P><CENTER> News in "
					+ fl.getFullName()
					+ ": &nbsp "
					+ count
					+ "</CENTER></P><BR>");
		} catch (MessagingException e) {
			out.println("<P><CENTER>Error during getting news count</CENTER>");
			out.println("</body></html>");
			out.close();
			return;
		}
		try {
			mes = fl.getMessage(0);
			while (mes != null) {
				if ((mes.getSubject() != null) && correctType(mes)) {
					out.println(
						"<table border=8 colomn=1 CELLSPACING=10 ALIGN=CENTER>");
					out.println("<tr>");
					out.println("<td>");
					dumpPart(mes, out);
					out.println("</td>");
					out.println("</tr>");
					out.println("</table>");
					break;
				}
				mes = fl.getMessage(0);
			}
		} catch (Exception e) {
			e.printStackTrace();
			out.println("<CENTER><P>Error during getting news</P>");
			out.println("</P><CENTER>");
			out.println("</body></html>");
			out.close();
			return;
		}
		if (mes != null) {
			out.println(
				"<CENTER><FORM ACTION=\"../servlet/GetNextNews\" METHOD=POST TARGET=\"SecondFrame\">");
			out.println("<BR><BR><P><INPUT TYPE=\"submit\" VALUE=\"Next\" >");
			out.println(
				"<INPUT TYPE=\"hidden\" VALUE=\"Next\" NAME=\"tr\"></P></FORM></CENTER>");
		} else {
			out.println("<P><CENTER>No other news</CENTER></P>");
		}
		out.println("</body></html>");
		out.close();
	}

	/**
	 * The content of the given Part object is sent into the given
	 * PrintWriter stream.
	 *
	 * @param   m  Part object to be transfered
	 * @param   out  PrintWriter in which the content is sent
	 * @exception   Exception  if IOException occurs
	 */
	private void dumpPart(Part m, PrintWriter out) throws Exception {
		Multipart mp = null;
		InputStream in = null;
		Object o = null;
		int count = 0;
		int c = 0;

		if (m instanceof Message) {
			dumpEnvelope((Message) m, out);
		}
		o = m.getContent();
		if (o instanceof String) {
			out.println("<P>" + (String) o + "</P>");
		} else if (o instanceof Multipart) {
			mp = (Multipart) o;
			count = mp.getCount();
			for (int i = 0; i < count; i++) {
				out.println("<P>");
				dumpPart(mp.getBodyPart(i), out);
			}
		} else if (o instanceof InputStream) {
			in = (InputStream) o;
			while ((c = in.read()) != -1) {
				out.write(c);
			}
		}
	}

	/**
	 * The content of the given Message object is sent into the given
	 * PrintWriter stream.
	 *
	 * @param   m  Message object to be transfered
	 * @param   out  PrintWriter in which the content is sent
	 * @exception   Exception  if IOException occurs
	 */
	private void dumpEnvelope(Message m, PrintWriter out) throws Exception {
		Address[] a = null;
		Date d = null;

		out.println("<P><B>NUM:</B> " + m.getMessageNumber() + "</P>");
		a = m.getFrom();
		if (a != null) {
			for (int i = 0; i < a.length; i++) {
				out.println("<P><B>FROM:</B> " + a[i].toString() + "</P>");
			}
		}
		a = m.getRecipients(Message.RecipientType.TO);
		if (a != null) {
			for (int i = 0; i < a.length; i++) {
				out.println("<P><B>TO:</B> " + a[i].toString() + "</P>");
			}
		}
		out.println("<P><B>SUBJECT:</B> " + m.getSubject() + "</P>");
		d = m.getSentDate();
		out.println(
			"<P><B>SENT DATE:</B> "
				+ (d != null ? d.toString() : "unknown")
				+ "</P>");
		out.println("<hr WIDTH=\"100%\">");
	}

	/**
	 * Checks if type of the given message is correctly set.
	 *
	 * @param   m  the message to be checked
	 * @return     true if type of the given message is correctly set; false otherwise
	 */
	private boolean correctType(Message m) {
		String str = new String("");

		try {
			str = m.getContentType();
		} catch (MessagingException e) {
		}

		return (str.startsWith("text/plain") || str.startsWith("multi/mixed"));
	}

}
