package com.sap.engine.examples.javamail.servlet;
import java.io.IOException;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import java.io.*;
import javax.mail.*;
import java.util.Date;

public class GetMessages extends HttpServlet {
	public void service(
		HttpServletRequest request,
		HttpServletResponse response)
		throws ServletException, IOException {
		PrintWriter out = null;
		Message mes = null;
		Folder fl = null;
		HttpSession session = request.getSession(false);
		String beginIndStr = request.getParameter("beginInd").trim();
		String lastIndStr = request.getParameter("lastInd").trim();
		String maxCountStr = request.getParameter("maxCount").trim();
		int beginInd = 0;
		int lastInd = 0;
		int maxCount = 10;

		try {
			maxCount = new Integer(maxCountStr).intValue();
		} catch (Exception e) {
		}
		try {
			beginInd = new Integer(beginIndStr).intValue();
		} catch (Exception e) {
			beginInd = 1;
		}
		try {
			lastInd = new Integer(lastIndStr).intValue();
		} catch (Exception e) {
			lastInd = maxCount;
		}
		if (beginInd < 1 || beginInd > maxCount) {
			beginInd = 1;
		}
		if (lastInd < 1 || lastInd > maxCount) {
			lastInd = maxCount;
		}
		if (beginInd > lastInd) {
			beginInd = 1;
			lastInd = 10;
		}
		response.setContentType("text/html");
		out = new PrintWriter(response.getOutputStream());
		out.println("<html>");
		out.println("<head><title>CheckMail</title></head>");
		out.println("<STYLE>");
		out.println(
			"H2 { color: #000000; font-family: \"Verdana\", \"Arial\", \"Helvetica\", \"Sans-serif\"; font-size: 14px }");
		out.println(
			"P { font-family: \"Verdana\", \"Arial\", \"Helvetica\", \"Sans-serif\"; font-size: 12px }");
		out.println("A:visited { color: #FEBD06 }");
		out.println("A:link { color: #FEBD06 }");
		out.println("</STYLE>");
		out.println("<BODY>");
		fl = (Folder) session.getAttribute("folder");
		out.println("<table border=8 colomn=1 CELLSPACING=30 >");
		for (int i = beginInd; i < lastInd + 1; i++) {
			out.println("<tr>");
			out.println("<td>");
			out.println("<P><B>Message number:</B> " + i + "</P>");
			try {
				mes = fl.getMessage(i);
				dumpPart(mes, out, session);
			} catch (Exception e) {
				out.println(
					"<P><CENTER>Error during retrieving message from folder</CENTER></P>");
			}
			out.println("</td>");
			out.println("</tr>");
		}
		out.println("</table>");
		out.println("</body></html>");
		out.close();
	}
	/**
	 * The content of the given Part object is sent into the given
	 * PrintWriter stream.
	 *
	 * @param   m  Part object to be transfered
	 * @param   out  PrintWriter in which the content is sent
	 * @exception   Exception  if IOException occurs
	 */
	private void dumpPart(Part m, PrintWriter out, HttpSession session)
		throws Exception {
		InputStream in = null;
		Multipart mp = null;
		Object o = null;
		int c = 0;
		int count = 0;

		if (m instanceof Message) {
			dumpEnvelope((Message) m, out);
		}
		o = m.getContent();

		if (m.getFileName() != null) {
			String fileName = m.getFileName();
			String absFileName =
				(String) session.getAttribute("workDir")
					+ File.separator
					+ fileName;
			FileOutputStream fos = new FileOutputStream(absFileName);
			if (o instanceof String) {
				fos.write(((String) o).getBytes());
			} else {
				in = (InputStream) o;
				byte[] buffer = new byte[in.available()];
				in.read(buffer);
				fos.write(buffer);
			}
			fos.close();
			File orgFile = new File(absFileName);
			out.println(
				"<P>Attachment:   <A HREF=\""
					+ "file://"
					+ orgFile.getAbsolutePath()
					+ "\"> "
					+ fileName
					+ "</A> &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; size: "
					+ orgFile.length()
					+ " bytes</P>");
		} else if (o instanceof String) {
			out.println("<P>" + (String) o + "</P>");

		} else if (o instanceof Multipart) {
			mp = (Multipart) o;
			count = mp.getCount();
			for (int i = 0; i < count; i++) {
				out.println("<HR><P>");
				dumpPart(mp.getBodyPart(i), out, session);
			}

		} else if (o instanceof InputStream) {
			in = (InputStream) o;
			while ((c = in.read()) != -1) {
				out.write(c);
			}
		}
	}

	/**
	 * The content of the given Message object is sent into the given
	 * PrintWriter stream.
	 *
	 * @param   m  Message object to be transfered
	 * @param   out  PrintWriter in which the content is sent
	 * @exception   Exception  if IOException occurs
	 */
	private void dumpEnvelope(Message m, PrintWriter out) throws Exception {
		Address[] a = null;
		Flags.Flag[] sf = null;
		Date d = null;
		Flags f = null;

		a = m.getFrom();
		if (a != null) {
			for (int i = 0; i < a.length; i++) {
				out.println("<P><B>FROM:</B> " + a[i].toString() + "<BR></P>");
			}
		}
		a = m.getRecipients(Message.RecipientType.TO);
		if (a != null) {
			for (int i = 0; i < a.length; i++) {
				out.println("<P><B>TO:</B> " + a[i].toString() + "<BR></P>");
			}
		}
		out.println("<P><B>SUBJECT:</B> " + m.getSubject() + "<BR></P>");
		d = m.getSentDate();
		out.println(
			"<P><B>SENT DATE:</B> "
				+ (d != null ? d.toString() : "unknown")
				+ "<BR></P>");
		f = m.getFlags();
		sf = f.getSystemFlags();
		out.println("<P><B>FLAGS:</B></P> ");
		if (sf.length == 0) {
			out.println("<P>Flags are not set</P>");
		}
		for (int i = 0; i < sf.length; i++) {
			if (sf[i] == Flags.Flag.DELETED) {
				out.println("/deleted");
			} else if (sf[i] == Flags.Flag.SEEN) {
				out.println("/seen");
			} else if (sf[i] == Flags.Flag.RECENT) {
				out.println("/recent");
			} else if (sf[i] == Flags.Flag.ANSWERED) {
				out.println("/answered");
			} else if (sf[i] == Flags.Flag.DRAFT) {
				out.println("/draft");
			} else if (sf[i] == Flags.Flag.FLAGGED) {
				out.println("/flagged");
			} else if (sf[i] == Flags.Flag.USER) {
				out.println("/user");
			}
		}
		out.println("<hr WIDTH=\"100%\">");
	}

}
