package com.sap.engine.examples.javamail.servlet;
import java.io.IOException;

import javax.servlet.ServletException;
import javax.servlet.http.*;
import javax.mail.*;
import java.io.PrintWriter;
import java.io.InputStream;
import java.util.*;

public class GetFirstNews extends HttpServlet {

	public void service(
		HttpServletRequest request,
		HttpServletResponse response)
		throws ServletException, IOException {
		PrintWriter out = null;
		HttpSession sessionHTTP = null;
		Message mes = null;
		Folder defFl = null;
		Folder fl = null;
		String name = new String("");
		int k = 0;

		sessionHTTP = request.getSession(false);
		defFl = (Folder) sessionHTTP.getAttribute("defFolder");
		name = request.getParameter("name").trim();
		response.setContentType("text/html");
		out = new PrintWriter(response.getOutputStream());
		out.println("<html>");
		out.println("<head><title>ShowNews</title></head>");
		out.println("<STYLE>");
		out.println(
			"H2 { color: #000000; font-family: \"Verdana\", \"Arial\", \"Helvetica\", \"Sans-serif\"; font-size: 14px }");
		out.println(
			"P { font-family: \"Verdana\", \"Arial\", \"Helvetica\", \"Sans-serif\"; font-size: 12px }");
		out.println("A:visited { color: #FEBD06 }");
		out.println("A:link { color: #FEBD06 }");
		out.println("</STYLE>");
		out.println("<BODY>");
		try {
			fl = defFl.getFolder(name);
			fl.open(Folder.READ_WRITE);
			sessionHTTP.setAttribute("folder", fl);
		} catch (MessagingException e) {
			e.printStackTrace();
			out.println(
				"<CENTER><BR><BR><P>Error during retrieving news from newsgroup</P>");
			out.println("<CENTER>");
			out.println("</body></html>");
			out.close();
			return;
		}
		try {
			k = fl.getMessageCount();
		} catch (MessagingException e) {
			e.printStackTrace();
			out.println("<CENTER><P>Error during getting news count</P>");
			out.println("</CENTER>");
			out.println("</body></html>");
			out.close();
			return;
		}
		if (k == 0) {
			out.println(
				"<CENTER> <P>No news in " + name + " </P></CENTER><BR>");
			out.println("</body></html>");
			out.close();
			return;
		}
		out.println(
			"<CENTER> <P>News in "
				+ name
				+ ": &nbsp "
				+ k
				+ "</P></CENTER><BR>");
		try {
			mes = fl.getMessage(0);
			while (mes != null) {
				if (mes.getSubject() != null) {
					out.println(
						"<table border=8 colomn=1 CELLSPACING=10 ALIGN=CENTER>");
					out.println("<tr>");
					out.println("<td>");
					dumpPart(mes, out);
					out.println("</td>");
					out.println("</tr>");
					out.println("</table>");
					break;
				}
				mes = fl.getMessage(0);
			}
		} catch (Exception e) {
			out.println("<CENTER><P>Error during getting news</P>");
			out.println("</CENTER>");
			out.println("</body></html>");
			out.close();
			return;
		}
		out.println(
			"<FORM ACTION=\"../servlet/GetNextNews\" METHOD=POST TARGET=\"SecondFrame\">");
		out.println(
			"<CENTER><BR><BR><P><INPUT TYPE=\"submit\" VALUE=\"Next\"></P>");
		out.println(
			"<P><INPUT TYPE=\"hidden\" VALUE=\"Next\" NAME=\"yt\"></P></CENTER>");
		out.println("</FORM></body></html>");
		out.close();
	}

	/**
	 * The content of the given Part object is sent into the given
	 * PrintWriter stream.
	 *
	 * @param   m  Part object to be transfered
	 * @param   out  PrintWriter in which the content is sent
	 * @exception   Exception  if IOException occurs
	 */
	private void dumpPart(Part m, PrintWriter out) throws Exception {
		InputStream in = null;
		Multipart mp = null;
		Object o = null;
		int count = -1;
		int c = -1;

		if (m instanceof Message) {
			dumpEnvelope((Message) m, out);
		}
		o = m.getContent();
		if (o instanceof String) {
			out.println("<P>" + (String) o);
		} else if (o instanceof Multipart) {
			mp = (Multipart) o;
			count = mp.getCount();
			for (int i = 0; i < count; i++) {
				out.println("<P>");
				dumpPart(mp.getBodyPart(i), out);
			}
		} else if (o instanceof InputStream) {
			in = (InputStream) o;
			while ((c = in.read()) != -1) {
				out.write(c);
			}
		}
	}

	/**
	 * The content of the given Message object is sent into the given
	 * PrintWriter stream.
	 *
	 * @param   m  Message object to be transfered
	 * @param   out  PrintWriter in which the content is sent
	 * @exception   Exception  if IOException occurs
	 */
	private void dumpEnvelope(Message m, PrintWriter out) throws Exception {
		Address[] a = null;
		Date d = null;

		out.println("<P><B>NUM:</B> " + m.getMessageNumber() + "</P>");
		a = m.getFrom();
		if (a != null) {
			for (int i = 0; i < a.length; i++) {
				out.println("<P><B>FROM:</B> " + a[i].toString() + "</P>");
			}
		}
		a = m.getRecipients(Message.RecipientType.TO);
		if (a != null) {
			for (int i = 0; i < a.length; i++) {
				out.println("<P><B>TO:</B> " + a[i].toString() + "</P>");
			}
		}
		out.println("<P><B>SUBJECT:</B> " + m.getSubject() + "</P>");
		d = m.getSentDate();
		out.println(
			"<P><B>SENT DATE:</B> "
				+ (d != null ? d.toString() : "unknown")
				+ "</P>");
		out.println("<hr WIDTH=\"100%\">");
	}

}
