package com.sap.engine.examples.ejb.javamail;
import javax.ejb.SessionBean;
import javax.ejb.SessionContext;
import javax.ejb.CreateException;
import javax.naming.*;
import javax.mail.*;
import javax.mail.internet.*;
import javax.activation.*;
import java.util.*;
/**
 * @ejbHome <{com.sap.engine.examples.ejb.javamail.SendMailHome}>
 * @ejbLocal <{com.sap.engine.examples.ejb.javamail.SendMailLocal}>
 * @ejbLocalHome <{com.sap.engine.examples.ejb.javamail.SendMailLocalHome}>
 * @ejbRemote <{com.sap.engine.examples.ejb.javamail.SendMail}>
 * @transactionType Container
 */
public class SendMailBean implements SessionBean {
	/**
	 * SMTP server name
	 */
	private String host;

	/**
	 * sender email address 
	 */
	private String from;
  
	/**
	 * recepient email address 
	 */
	private String to;
  
	/**
	 * subject of the message
	 */
	private String subject;
  
	/**
	 * the separate text message parts of a MultiPart message 
	 */
	private String[] messages;

	/**
	 * name of attached file; in this example only a single attachment is supported
	 */
	private String attachment;

	public void ejbRemove() {
	}

	public void ejbActivate() {
	}

	public void ejbPassivate() {
	}

	public void setSessionContext(SessionContext context) {
		myContext = context;
	}

	private SessionContext myContext;
	/**
	 * Business Method.
	 */
	public String getHost() {
		return host;
	}


	/**
	 * Business Method.
	 */
	public void setHost(String host) {
		this.host = host;
	}


	/**
	 * Business Method.
	 */
	public String getFrom() {
		return from;
	}


	/**
	 * Business Method.
	 */
	public void setFrom(String from) {
		this.from = from;
	}


	/**
	 * Business Method.
	 */
	public String getTo() {
		return to;
	}


	/**
	 * Business Method.
	 */
	public void setTo(String to) {
		this.to = to;
	}


	/**
	 * Business Method.
	 */
	public String getSubject() {
		return subject;
	}


	/**
	 * Business Method.
	 */
	public void setSubject(String subject) {
		this.subject = subject;
	}


	/**
	 * Business Method.
	 */
	public String[] getMessages() {
		return messages;
	}


	/**
	 * Business Method.
	 */
	public void setMessages(String[] messages) {
		this.messages = messages;
	}


	/**
	 * Business Method.
	 */
	public String getAttachedFileName() {
		return attachment;
	}


	/**
	 * Business Method.
	 */
	public void setAttachedFileName(String attachment) {
		this.attachment = attachment;
	}


	/**
	 * Business Method.
	 */
	public void send() throws SendMailException{
		try {
			InitialContext ctx = new InitialContext();
			Session sess = (Session) javax.rmi.PortableRemoteObject.narrow(ctx.lookup("java:comp/env/mail/MailSession"), Session.class);
			Message msg = new MimeMessage(sess);
			msg.setFrom(new InternetAddress(from));
			msg.setRecipients(Message.RecipientType.TO, extractRecipientAddresses(to));
			msg.setSubject(subject);
			boolean hasAttachment = (attachment != null) && (attachment.length() > 0);
			boolean isMultiPart = (messages != null) && (messages.length > 1);
		  // adding an attachment makes the message multipart 
			if (isMultiPart || hasAttachment) {
				Multipart mp = new MimeMultipart();
			// add text parts
				if (messages != null) {
					for (int i = 0; i < messages.length; i++) {
						MimeBodyPart bodyPart = new MimeBodyPart();
						bodyPart.setContent(messages[i], "text/plain");
						mp.addBodyPart(bodyPart);
					}
				}
			// attach the file to the message if needed
				if (hasAttachment) {
				// avoid the case with no text parts
					MimeBodyPart bodyPart = new MimeBodyPart();
					bodyPart.setContent("Attachment enclosed.", "text/plain");
					mp.addBodyPart(bodyPart);
				// the part with the file        	
					FileDataSource fds = new FileDataSource(attachment);
					MimeBodyPart attachmentBodyPart = new MimeBodyPart();
					attachmentBodyPart.setDataHandler(new DataHandler(fds));
					attachmentBodyPart.setFileName(fds.getName());
					mp.addBodyPart(attachmentBodyPart);
				}
				msg.setContent(mp);
			} else {
				if ((messages != null) && (messages.length>0)) {
					msg.setContent(messages[0], "text/plain");
				} else {
					msg.setContent("", "text/plain");
				}
			}
			msg.setSentDate(new GregorianCalendar().getTime());
			msg.saveChanges();
			Transport tr = sess.getTransport("smtp");
			tr.connect(host, "", "");
			Address[] address = msg.getAllRecipients();
			tr.sendMessage(msg, address);
			tr.close();
		} catch (Exception e) {
			throw new SendMailException(e.getMessage());
		}
	}


	/**
	 * Create Method.
	 */
	public void ejbCreate() throws CreateException {

	}

	/**
	 * Converts the given String object to an array of InternetAddress 
	 * objects containing the addresses kept in the given String object.
	 *
	 * @param   str  String object which keeps addresses of the message to be send
	 * @return       the converted InternetAddress objects
	 */
private InternetAddress[] extractRecipientAddresses(String str) {
	StringTokenizer st = new StringTokenizer(str, " ;,:");
	InternetAddress[] rcpt = new InternetAddress[st.countTokens()];

	try {
	  for (int i = 0; i < rcpt.length; i++) {
		rcpt[i] = new InternetAddress(st.nextToken());
	  }
	} catch (Exception e) {
	  return new InternetAddress[0];
	}
    
	return rcpt;
  }

}
